/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document.output;

import com.lowagie.text.rtf.document.output.RtfDataCache;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RtfDiskCache
implements RtfDataCache {
    private final BufferedOutputStream data;
    private final File tempFile = File.createTempFile("iText", null);

    public RtfDiskCache() throws IOException {
        this.data = new BufferedOutputStream(new FileOutputStream(this.tempFile));
    }

    @Override
    public OutputStream getOutputStream() {
        return this.data;
    }

    @Override
    public void writeTo(OutputStream target) throws IOException {
        int bytesRead;
        this.data.close();
        BufferedInputStream tempIn = new BufferedInputStream(new FileInputStream(this.tempFile));
        byte[] buffer = new byte[8192];
        while ((bytesRead = tempIn.read(buffer)) >= 0) {
            target.write(buffer, 0, bytesRead);
        }
        tempIn.close();
        this.tempFile.delete();
    }
}

