/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.utils;

import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class LongMappedByteBuffer {
    private static final long CHUNK_SIZE = Integer.MAX_VALUE;
    private final MappedByteBuffer[] chunks;
    private final long size;
    private long position = 0L;

    public LongMappedByteBuffer(FileChannel channel, FileChannel.MapMode mode) throws IOException {
        this.size = channel.size();
        int numChunks = (int)((this.size + Integer.MAX_VALUE - 1L) / Integer.MAX_VALUE);
        this.chunks = new MappedByteBuffer[numChunks];
        for (int i = 0; i < numChunks; ++i) {
            long pos = (long)i * Integer.MAX_VALUE;
            long chunkSize = Math.min(Integer.MAX_VALUE, this.size - pos);
            this.chunks[i] = channel.map(mode, pos, chunkSize);
        }
    }

    public byte get() {
        byte b = this.get(this.position);
        ++this.position;
        return b;
    }

    public byte get(long pos) {
        if (pos >= this.size) {
            throw new BufferUnderflowException();
        }
        int chunkIndex = (int)(pos / Integer.MAX_VALUE);
        int offset = (int)(pos % Integer.MAX_VALUE);
        MappedByteBuffer chunk = this.chunks[chunkIndex];
        return chunk.get(offset);
    }

    public void get(long pos, byte[] dst, int off, int len) {
        int toRead;
        if (off < 0 || len < 0 || off + len > dst.length) {
            throw new IndexOutOfBoundsException("Invalid offset/length");
        }
        long readPos = pos;
        int dstPos = off;
        for (int remaining = len; remaining > 0; remaining -= toRead) {
            int chunkIndex = (int)(readPos / Integer.MAX_VALUE);
            int chunkOffset = (int)(readPos % Integer.MAX_VALUE);
            int chunkRemaining = this.chunks[chunkIndex].limit() - chunkOffset;
            toRead = Math.min(remaining, chunkRemaining);
            MappedByteBuffer dup = this.chunks[chunkIndex].duplicate();
            ((ByteBuffer)dup).position(chunkOffset);
            dup.get(dst, dstPos, toRead);
            readPos += (long)toRead;
            dstPos += toRead;
        }
    }

    public void get(byte[] dst, int off, int len) {
        this.get(this.position, dst, off, len);
        this.position += (long)len;
    }

    public void put(byte value) {
        this.put(this.position, value);
        ++this.position;
    }

    public void put(long pos, byte value) {
        int chunkIndex = (int)(pos / Integer.MAX_VALUE);
        int offset = (int)(pos % Integer.MAX_VALUE);
        this.chunks[chunkIndex].put(offset, value);
    }

    public void put(byte[] src, int off, int len) {
        int toWrite;
        if (off < 0 || len < 0 || off + len > src.length) {
            throw new IndexOutOfBoundsException("Invalid offset/length");
        }
        int srcPos = off;
        long pos = this.position;
        for (int remaining = len; remaining > 0; remaining -= toWrite) {
            int chunkIndex = (int)(pos / Integer.MAX_VALUE);
            int chunkOffset = (int)(pos % Integer.MAX_VALUE);
            int chunkRemaining = this.chunks[chunkIndex].limit() - chunkOffset;
            toWrite = Math.min(remaining, chunkRemaining);
            MappedByteBuffer dup = this.chunks[chunkIndex].duplicate();
            ((ByteBuffer)dup).position(chunkOffset);
            dup.put(src, srcPos, toWrite);
            pos += (long)toWrite;
            srcPos += toWrite;
        }
        this.position = pos;
    }

    public int read(byte[] bytes, int off, int len) {
        long limit;
        long pos = this.position();
        if (pos >= (limit = this.limit())) {
            return -1;
        }
        int available = (int)Math.min((long)len, limit - pos);
        this.get(pos, bytes, off, available);
        this.position(pos + (long)available);
        return available;
    }

    public long position() {
        return this.position;
    }

    public LongMappedByteBuffer position(long newPosition) {
        if (newPosition < 0L || newPosition > this.size) {
            throw new IllegalArgumentException("Position out of bounds");
        }
        this.position = newPosition;
        return this;
    }

    public long size() {
        return this.size;
    }

    public long limit() {
        return this.size;
    }

    public LongMappedByteBuffer load() {
        for (MappedByteBuffer chunk : this.chunks) {
            chunk.load();
        }
        return this;
    }

    public boolean isLoaded() {
        for (MappedByteBuffer chunk : this.chunks) {
            if (chunk.isLoaded()) continue;
            return false;
        }
        return true;
    }

    public void force() {
        for (MappedByteBuffer chunk : this.chunks) {
            chunk.force();
        }
    }
}

