/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.annotation;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.openpdf.renderer.PDFCmd;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFParseException;
import org.openpdf.renderer.annotation.AnnotationType;
import org.openpdf.renderer.annotation.MarkupAnnotation;
import org.openpdf.renderer.annotation.TextMarkupAnnotation;

public class PDFAnnotation {
    public static final String GOTO = "GoTo";
    public static final String GOTOE = "GoToE";
    public static final String GOTOR = "GoToR";
    public static final String URI = "URI";
    private final PDFObject pdfObj;
    private final AnnotationType type;
    private final Rectangle2D.Float rect;
    private final String subType;
    private final String contents;
    private final String annotationName;
    private String modified;
    private Integer flags;
    private String appearanceState;

    public PDFAnnotation(PDFObject annotObject) throws IOException {
        this(annotObject, AnnotationType.UNKNOWN);
    }

    public PDFAnnotation(PDFObject annotObject, AnnotationType type) throws IOException {
        this.pdfObj = annotObject;
        this.type = type;
        this.subType = annotObject.getDictRefAsString("Subtype");
        this.contents = annotObject.getDictRefAsString("Contents");
        this.annotationName = annotObject.getDictRefAsString("NM");
        this.modified = annotObject.getDictRefAsString("M");
        this.flags = annotObject.getDictRefAsInt("F");
        this.appearanceState = annotObject.getDictRefAsString("AS");
        this.rect = this.parseRect(annotObject.getDictRef("Rect"));
    }

    public static PDFAnnotation createAnnotation(PDFObject parent) throws IOException {
        String sigTypeS;
        PDFObject sigType;
        PDFObject subtypeValue = parent.getDictRef("Subtype");
        if (subtypeValue == null) {
            return null;
        }
        String subtypeS = subtypeValue.getStringValue();
        AnnotationType annotationType = AnnotationType.getByDefinition(subtypeS);
        if (annotationType == AnnotationType.WIDGET && (sigType = parent.getDictRef("FT")) != null && AnnotationType.getByDefinition(sigTypeS = sigType.getStringValue()) == AnnotationType.SIGNATURE) {
            annotationType = AnnotationType.getByDefinition(sigTypeS);
        }
        if (annotationType.displayAnnotation()) {
            Class<?> className = annotationType.getClassName();
            try {
                Constructor<?> constructor;
                if (className.equals(MarkupAnnotation.class) || className.equals(TextMarkupAnnotation.class)) {
                    constructor = className.getConstructor(PDFObject.class, AnnotationType.class);
                    return (PDFAnnotation)constructor.newInstance(new Object[]{parent, annotationType});
                }
                constructor = className.getConstructor(PDFObject.class);
                return (PDFAnnotation)constructor.newInstance(parent);
            }
            catch (Exception e) {
                throw new PDFParseException("Could not parse annotation!", e);
            }
        }
        return null;
    }

    public Rectangle2D.Float parseRect(PDFObject obj) throws IOException {
        if (obj.getType() == 5) {
            PDFObject[] bounds = obj.getArray();
            if (bounds.length == 4) {
                return new Rectangle2D.Float(bounds[0].getFloatValue(), bounds[1].getFloatValue(), bounds[2].getFloatValue() - bounds[0].getFloatValue(), bounds[3].getFloatValue() - bounds[1].getFloatValue());
            }
            throw new PDFParseException("Rectangle definition didn't have 4 elements");
        }
        throw new PDFParseException("Rectangle definition not an array");
    }

    public PDFObject getPdfObj() {
        return this.pdfObj;
    }

    public AnnotationType getType() {
        return this.type;
    }

    public Rectangle2D.Float getRect() {
        return this.rect;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getAnnotationName() {
        return this.annotationName;
    }

    public String getAppearanceState() {
        return this.appearanceState;
    }

    public String getContents() {
        return this.contents;
    }

    public Integer getFlags() {
        return this.flags;
    }

    public boolean isFlagSet(Flags flag) {
        return this.flags != null && BigInteger.valueOf(this.flags.intValue()).testBit(flag.ordinal());
    }

    public String getModified() {
        return this.modified;
    }

    public String toString() {
        return this.pdfObj.toString();
    }

    public List<PDFCmd> getPageCommandsForAnnotation() {
        return new ArrayList<PDFCmd>();
    }

    protected AffineTransform getScalingTransformation(Rectangle2D.Float bbox) {
        AffineTransform at = new AffineTransform();
        double scaleHeight = this.getRect().getHeight() / bbox.getHeight();
        double scaleWidth = this.getRect().getWidth() / bbox.getWidth();
        at.scale(scaleWidth, scaleHeight);
        return at;
    }

    public static enum Flags {
        UNKNOWN,
        INVISIBLE,
        HIDDEN,
        PRINT,
        NO_ZOOM,
        NO_ROTATE,
        NO_VIEW,
        READ_ONLY,
        LOCKED,
        TOGGLE_NO_VIEW,
        LOCKED_CONTENTS;

    }
}

