/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.font;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.openpdf.renderer.PDFPage;
import org.openpdf.renderer.PDFShapeCmd;

public class PDFGlyph {
    private final char src;
    private final String name;
    private final Point2D advance;
    private GeneralPath shape;
    private PDFPage page;

    public PDFGlyph(char src, String name, GeneralPath shape, Point2D.Float advance) {
        this.shape = shape;
        this.advance = advance;
        this.src = src;
        this.name = name;
    }

    public PDFGlyph(char src, String name, PDFPage page, Point2D advance) {
        this.page = page;
        this.advance = advance;
        this.src = src;
        this.name = name;
    }

    public char getChar() {
        return this.src;
    }

    public String getName() {
        return this.name;
    }

    public GeneralPath getShape() {
        return this.shape;
    }

    public PDFPage getPage() {
        return this.page;
    }

    public Point2D addCommands(PDFPage cmds, AffineTransform transform, int mode) {
        if (this.shape != null) {
            GeneralPath outline = (GeneralPath)this.shape.createTransformedShape(transform);
            cmds.addCommand(new PDFShapeCmd(outline, mode, false));
        } else if (this.page != null) {
            cmds.addCommands(this.page, transform);
        }
        return this.advance;
    }

    public Point2D getAdvance() {
        return this.advance;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.name);
        return str.toString();
    }
}

