/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.annotation;

import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openpdf.renderer.PDFCmd;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFPage;
import org.openpdf.renderer.PDFShapeCmd;
import org.openpdf.renderer.annotation.AnnotationType;
import org.openpdf.renderer.annotation.MarkupAnnotation;

public class TextMarkupAnnotation
extends MarkupAnnotation {
    private int[] quadPoints;
    private List<PDFCmd> highlightCommands;

    public TextMarkupAnnotation(PDFObject annotObject, AnnotationType annotationType) throws IOException {
        super(annotObject, annotationType);
        this.quadPoints = annotObject.getDictRefAsIntArray("QuadPoints");
        if (annotObject.getDictRef("AP") == null) {
            this.parseHighlightCommands();
        }
    }

    private void parseHighlightCommands() {
        if (this.quadPoints == null || this.quadPoints.length % 4 != 0) {
            return;
        }
        this.highlightCommands = new ArrayList<PDFCmd>();
        this.highlightCommands.add(PDFPage.createPushCmd());
        for (int i = 0; i < this.quadPoints.length; i += 4) {
            GeneralPath gp = new GeneralPath(new Rectangle(this.quadPoints[i], this.quadPoints[i + 1], this.quadPoints[i + 2], this.quadPoints[i + 3]));
            this.highlightCommands.add(new PDFShapeCmd(gp, 2, true));
        }
        this.highlightCommands.add(PDFPage.createPopCmd());
    }

    @Override
    public List<PDFCmd> getCurrentCommand() {
        List<PDFCmd> apCommand = super.getCurrentCommand();
        if (apCommand != null) {
            return apCommand;
        }
        return this.highlightCommands;
    }
}

