/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.function.postscript.operation;

import java.util.HashMap;
import java.util.Map;
import org.openpdf.renderer.function.postscript.operation.Abs;
import org.openpdf.renderer.function.postscript.operation.Add;
import org.openpdf.renderer.function.postscript.operation.And;
import org.openpdf.renderer.function.postscript.operation.Atan;
import org.openpdf.renderer.function.postscript.operation.Bitshift;
import org.openpdf.renderer.function.postscript.operation.Ceiling;
import org.openpdf.renderer.function.postscript.operation.Copy;
import org.openpdf.renderer.function.postscript.operation.Cvi;
import org.openpdf.renderer.function.postscript.operation.Cvr;
import org.openpdf.renderer.function.postscript.operation.Div;
import org.openpdf.renderer.function.postscript.operation.Dup;
import org.openpdf.renderer.function.postscript.operation.Eq;
import org.openpdf.renderer.function.postscript.operation.Exch;
import org.openpdf.renderer.function.postscript.operation.Exp;
import org.openpdf.renderer.function.postscript.operation.False;
import org.openpdf.renderer.function.postscript.operation.Floor;
import org.openpdf.renderer.function.postscript.operation.Ge;
import org.openpdf.renderer.function.postscript.operation.Gt;
import org.openpdf.renderer.function.postscript.operation.Idiv;
import org.openpdf.renderer.function.postscript.operation.If;
import org.openpdf.renderer.function.postscript.operation.IfElse;
import org.openpdf.renderer.function.postscript.operation.Index;
import org.openpdf.renderer.function.postscript.operation.Le;
import org.openpdf.renderer.function.postscript.operation.Ln;
import org.openpdf.renderer.function.postscript.operation.Log;
import org.openpdf.renderer.function.postscript.operation.Lt;
import org.openpdf.renderer.function.postscript.operation.Mod;
import org.openpdf.renderer.function.postscript.operation.Mul;
import org.openpdf.renderer.function.postscript.operation.Ne;
import org.openpdf.renderer.function.postscript.operation.Neg;
import org.openpdf.renderer.function.postscript.operation.Not;
import org.openpdf.renderer.function.postscript.operation.Or;
import org.openpdf.renderer.function.postscript.operation.Pop;
import org.openpdf.renderer.function.postscript.operation.PostScriptOperation;
import org.openpdf.renderer.function.postscript.operation.PushAsNumber;
import org.openpdf.renderer.function.postscript.operation.Roll;
import org.openpdf.renderer.function.postscript.operation.Round;
import org.openpdf.renderer.function.postscript.operation.Sin;
import org.openpdf.renderer.function.postscript.operation.Sqrt;
import org.openpdf.renderer.function.postscript.operation.Sub;
import org.openpdf.renderer.function.postscript.operation.True;
import org.openpdf.renderer.function.postscript.operation.Truncate;
import org.openpdf.renderer.function.postscript.operation.Xor;

public class OperationSet {
    private Map<String, PostScriptOperation> operationSet = null;
    private static OperationSet instance;

    private OperationSet() {
        this.initOperations();
    }

    public static synchronized OperationSet getInstance() {
        if (instance == null) {
            instance = new OperationSet();
        }
        return instance;
    }

    public PostScriptOperation getOperation(String token) {
        PostScriptOperation result = this.operationSet.get(token.trim().toLowerCase());
        if (result == null) {
            result = new PushAsNumber(token);
        }
        return result;
    }

    private void initOperations() {
        if (this.operationSet == null) {
            this.operationSet = new HashMap<String, PostScriptOperation>();
            this.operationSet.put("abs", new Abs());
            this.operationSet.put("add", new Add());
            this.operationSet.put("atan", new Atan());
            this.operationSet.put("ceiling", new Ceiling());
            this.operationSet.put("cvi", new Cvi());
            this.operationSet.put("cvr", new Cvr());
            this.operationSet.put("div", new Div());
            this.operationSet.put("exp", new Exp());
            this.operationSet.put("floor", new Floor());
            this.operationSet.put("idiv", new Idiv());
            this.operationSet.put("ln", new Ln());
            this.operationSet.put("log", new Log());
            this.operationSet.put("mod", new Mod());
            this.operationSet.put("mul", new Mul());
            this.operationSet.put("neg", new Neg());
            this.operationSet.put("round", new Round());
            this.operationSet.put("sin", new Sin());
            this.operationSet.put("sqrt", new Sqrt());
            this.operationSet.put("sub", new Sub());
            this.operationSet.put("truncate", new Truncate());
            this.operationSet.put("and", new And());
            this.operationSet.put("bitshift", new Bitshift());
            this.operationSet.put("eq", new Eq());
            this.operationSet.put("false", new False());
            this.operationSet.put("ge", new Ge());
            this.operationSet.put("gt", new Gt());
            this.operationSet.put("le", new Le());
            this.operationSet.put("lt", new Lt());
            this.operationSet.put("ne", new Ne());
            this.operationSet.put("not", new Not());
            this.operationSet.put("or", new Or());
            this.operationSet.put("true", new True());
            this.operationSet.put("xor", new Xor());
            this.operationSet.put("if", new If());
            this.operationSet.put("ifelse", new IfElse());
            this.operationSet.put("copy", new Copy());
            this.operationSet.put("dup", new Dup());
            this.operationSet.put("exch", new Exch());
            this.operationSet.put("index", new Index());
            this.operationSet.put("pop", new Pop());
            this.operationSet.put("roll", new Roll());
        }
    }
}

