/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.colorspace;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.PDFPaint;
import org.openpdf.renderer.PDFParseException;
import org.openpdf.renderer.colorspace.AlternateColorSpace;
import org.openpdf.renderer.colorspace.CMYKColorSpace;
import org.openpdf.renderer.colorspace.CalGrayColor;
import org.openpdf.renderer.colorspace.CalRGBColor;
import org.openpdf.renderer.colorspace.IndexedColor;
import org.openpdf.renderer.colorspace.LabColor;
import org.openpdf.renderer.colorspace.PatternSpace;
import org.openpdf.renderer.function.PDFFunction;

public class PDFColorSpace {
    public static final int COLORSPACE_GRAY = 0;
    public static final int COLORSPACE_RGB = 1;
    public static final int COLORSPACE_CMYK = 2;
    public static final int COLORSPACE_PATTERN = 3;
    private static PDFColorSpace rgbSpace = new PDFColorSpace(ColorSpace.getInstance(1000));
    private static PDFColorSpace cmykSpace = new PDFColorSpace(new CMYKColorSpace());
    private static PDFColorSpace patternSpace;
    private static PDFColorSpace graySpace;
    ColorSpace cs;

    public PDFColorSpace(ColorSpace cs) {
        this.cs = cs;
    }

    public static PDFColorSpace getColorSpace(int name) {
        switch (name) {
            case 0: 
            case 6: 
            case 1003: {
                return graySpace;
            }
            case 1: {
                return rgbSpace;
            }
            case 2: {
                return cmykSpace;
            }
            case 3: {
                if (patternSpace == null) {
                    patternSpace = new PatternSpace();
                }
                return patternSpace;
            }
        }
        throw new IllegalArgumentException("Unknown Color Space name: " + name);
    }

    public static PDFColorSpace getColorSpace(PDFObject csobj, Map resources) throws IOException {
        String name;
        PDFObject colorSpaces = null;
        if (resources != null) {
            colorSpaces = (PDFObject)resources.get("ColorSpace");
        }
        if (csobj.getType() == 4) {
            name = csobj.getStringValue();
            if (name.equals("DeviceGray") || name.equals("G")) {
                return PDFColorSpace.getColorSpace(0);
            }
            if (name.equals("DeviceRGB") || name.equals("RGB")) {
                return PDFColorSpace.getColorSpace(1);
            }
            if (name.equals("DeviceCMYK") || name.equals("CMYK")) {
                return PDFColorSpace.getColorSpace(2);
            }
            if (name.equals("Pattern")) {
                return PDFColorSpace.getColorSpace(3);
            }
            if (colorSpaces != null) {
                csobj = colorSpaces.getDictRef(name);
            }
        }
        if (csobj == null) {
            return null;
        }
        if (csobj.getCache() != null) {
            return (PDFColorSpace)csobj.getCache();
        }
        PDFColorSpace value = null;
        PDFObject[] ary = csobj.getArray();
        name = ary[0].getStringValue();
        if (name.equals("DeviceGray") || name.equals("G")) {
            return PDFColorSpace.getColorSpace(0);
        }
        if (name.equals("DeviceRGB") || name.equals("RGB")) {
            return PDFColorSpace.getColorSpace(1);
        }
        if (name.equals("DeviceCMYK") || name.equals("CMYK")) {
            return PDFColorSpace.getColorSpace(2);
        }
        if (name.equals("CalGray")) {
            value = new PDFColorSpace(new CalGrayColor(ary[1]));
        } else if (name.equals("CalRGB")) {
            value = new PDFColorSpace(new CalRGBColor(ary[1]));
        } else if (name.equals("Lab")) {
            value = new PDFColorSpace(new LabColor(ary[1]));
        } else if (name.equals("ICCBased")) {
            try {
                ByteArrayInputStream bais = new ByteArrayInputStream(ary[1].getStream());
                ICC_Profile profile = ICC_Profile.getInstance(bais);
                if (profile.getColorSpaceType() == 1003 || profile.getColorSpaceType() == 6) {
                    return graySpace;
                }
                value = new PDFColorSpace(new ICC_ColorSpace(profile));
            }
            catch (IllegalArgumentException e) {
                return PDFColorSpace.getColorSpace(1);
            }
        } else if (name.equals("Separation") || name.equals("DeviceN")) {
            PDFColorSpace alternate = PDFColorSpace.getColorSpace(ary[2], resources);
            PDFFunction function = PDFFunction.getFunction(ary[3]);
            value = new AlternateColorSpace(alternate, function);
        } else if (name.equals("Indexed") || name.equals("I")) {
            PDFColorSpace refspace = PDFColorSpace.getColorSpace(ary[1], resources);
            int count = ary[2].getIntValue();
            try {
                value = new IndexedColor(refspace, count, ary[3]);
            }
            catch (Exception e) {
                value = refspace;
            }
        } else {
            if (name.equals("Pattern")) {
                if (ary.length == 1) {
                    return PDFColorSpace.getColorSpace(3);
                }
                PDFColorSpace base = PDFColorSpace.getColorSpace(ary[1], resources);
                return new PatternSpace(base);
            }
            if (name.equals("DeviceRGB")) {
                return PDFColorSpace.getColorSpace(1);
            }
            if (name.equals("DeviceCMYK")) {
                return PDFColorSpace.getColorSpace(2);
            }
            throw new PDFParseException("Unknown color space: " + name);
        }
        csobj.setCache(value);
        return value;
    }

    public int getNumComponents() {
        return this.cs.getNumComponents();
    }

    public PDFPaint getPaint(float[] components) {
        float[] rgb = this.cs.toRGB(components);
        return PDFPaint.getColorPaint(new Color(rgb[0], rgb[1], rgb[2]));
    }

    public ColorSpace getColorSpace() {
        return this.cs;
    }

    static {
        boolean useSGray = true;
        try {
            String resourcePath = "/sGray.icc";
            InputStream is = PDFColorSpace.class.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("ICC profile not found at " + resourcePath);
            }
            graySpace = new PDFColorSpace(!useSGray ? ColorSpace.getInstance(1003) : new ICC_ColorSpace(ICC_Profile.getInstance(is)));
            is.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

