/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.renderer.font;

import java.io.IOException;
import org.openpdf.renderer.PDFObject;
import org.openpdf.renderer.font.BuiltinFont;
import org.openpdf.renderer.font.PDFFontDescriptor;
import org.openpdf.renderer.font.PDFGlyph;
import org.openpdf.renderer.font.cid.PDFCMap;
import org.openpdf.renderer.font.ttf.AdobeGlyphList;

public class CIDFontType0
extends BuiltinFont {
    private PDFCMap glyphLookupMap;

    public CIDFontType0(String baseFont, PDFObject fontObj, PDFFontDescriptor descriptor) throws IOException {
        super(baseFont, fontObj, descriptor);
    }

    public void parseToUnicodeMap(PDFObject fontObj) throws IOException {
        PDFObject toUnicode = fontObj.getDictRef("ToUnicode");
        if (toUnicode != null) {
            PDFCMap cmap;
            this.glyphLookupMap = cmap = PDFCMap.getCMap(toUnicode);
        }
    }

    @Override
    protected PDFGlyph getGlyph(char src, String name) {
        if (this.glyphLookupMap != null) {
            src = this.glyphLookupMap.map(src);
            if (name == null && src != '\u00a0') {
                name = AdobeGlyphList.getGlyphName(src);
            }
        }
        return super.getGlyph(src, name);
    }
}

