/*
 * Decompiled with CFR 0.152.
 */
package test.myrenderer;

import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PDFRenderer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import javax.swing.JComponent;

public class PDFDisplay
extends JComponent {
    private static final long serialVersionUID = 1L;
    private byte[] bytes = null;
    private String fileName;
    private int pageIndex;

    public PDFDisplay(String fileName, int pageIndex) {
        this.fileName = fileName;
        this.pageIndex = pageIndex;
        this.readFile();
    }

    private void readFile() {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(this.fileName));){
            int b;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            while ((b = inputStream.read()) != -1) {
                outputStream.write(b);
            }
            this.bytes = outputStream.toByteArray();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        try {
            int formatOrientation;
            PDFFile pdfFile = new PDFFile(ByteBuffer.wrap(this.bytes));
            PDFPage page = pdfFile.getPage(this.pageIndex);
            Paper paper = new Paper();
            int n = formatOrientation = page.getAspectRatio() > 1.0f ? 0 : 1;
            if (formatOrientation == 0) {
                paper.setSize(page.getHeight(), page.getWidth());
            } else {
                paper.setSize(page.getWidth(), page.getHeight());
            }
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(paper);
            pageFormat.setOrientation(formatOrientation);
            Graphics2D g2d = (Graphics2D)g.create();
            Rectangle imgbounds = new Rectangle(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            PDFRenderer renderer = new PDFRenderer(page, g2d, imgbounds, null, Color.WHITE);
            try {
                page.waitForFinish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            renderer.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

