/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pdfview.decode;

import com.sun.pdfview.PDFObject;
import com.sun.pdfview.PDFParseException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public class RunLengthDecode {
    private static final int RUN_LENGTH_EOD = 128;
    private ByteBuffer buf;

    private RunLengthDecode(ByteBuffer buf) {
        this.buf = buf;
    }

    private ByteBuffer decode() {
        int dupAmount;
        this.buf.rewind();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[128];
        while ((dupAmount = this.buf.get() & 0xFF) != 128) {
            if (dupAmount >= 0 && dupAmount <= 127) {
                int amountToCopy = dupAmount + 1;
                this.buf.get(buffer, 0, amountToCopy);
                baos.write(buffer, 0, amountToCopy);
                continue;
            }
            byte dupByte = this.buf.get();
            for (int i = 0; i < 257 - dupAmount; ++i) {
                baos.write(dupByte);
            }
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    public static ByteBuffer decode(ByteBuffer buf, PDFObject params) throws PDFParseException {
        RunLengthDecode me = new RunLengthDecode(buf);
        return me.decode();
    }
}

