/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.swing;

import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.openpdf.extend.FSImage;
import org.openpdf.resource.ImageResource;
import org.openpdf.swing.AWTFSImage;
import org.openpdf.swing.ImageLoadItem;
import org.openpdf.swing.ImageLoadQueue;
import org.openpdf.swing.ImageResourceLoader;
import org.openpdf.util.ImageUtil;
import org.openpdf.util.XRLog;

class ImageLoadWorker
extends Thread {
    private static final AtomicInteger counter = new AtomicInteger(0);
    private final ImageLoadQueue queue;

    public ImageLoadWorker(ImageLoadQueue queue) {
        this.queue = queue;
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("ImageLoadWorker(" + counter.incrementAndGet() + ")");
    }

    @Override
    public void run() {
        try {
            ImageLoadItem loadItem;
            while (!ImageLoadQueue.isKillSwitch(loadItem = this.queue.getTask())) {
                boolean wasScaled;
                ImageResource ir = ImageResourceLoader.loadImageResourceFromUri(loadItem._uri);
                FSImage awtfsImage = ir.getImage();
                BufferedImage newImg = ((AWTFSImage)awtfsImage).getImage();
                XRLog.load(Level.FINE, String.valueOf(this) + ", loaded " + loadItem._uri);
                loadItem._imageResourceLoader.loaded(ir, newImg.getWidth(), newImg.getHeight());
                if (loadItem.haveTargetDimensions() && !ir.hasDimensions(loadItem._targetWidth, loadItem._targetHeight)) {
                    XRLog.load(Level.FINE, String.valueOf(this) + ", scaling " + loadItem._uri + " to " + loadItem._targetWidth + ", " + loadItem._targetHeight);
                    newImg = ImageUtil.getScaledInstance(newImg, loadItem._targetWidth, loadItem._targetHeight);
                    ImageResource sir = new ImageResource(ir.getImageUri(), AWTFSImage.createImage(newImg));
                    loadItem._imageResourceLoader.loaded(sir, newImg.getWidth(), newImg.getHeight());
                    wasScaled = true;
                } else {
                    wasScaled = false;
                }
                BufferedImage newImg1 = newImg;
                EventQueue.invokeLater(() -> loadItem._mfsImage.setImage(loadItem._uri, newImg1, wasScaled));
            }
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }
}

