/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.pdf;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.openpdf.extend.FSImage;
import org.openpdf.extend.ReplacedElement;
import org.openpdf.extend.ReplacedElementFactory;
import org.openpdf.extend.UserAgentCallback;
import org.openpdf.layout.LayoutContext;
import org.openpdf.pdf.BookmarkElement;
import org.openpdf.pdf.CheckboxFormField;
import org.openpdf.pdf.EmptyReplacedElement;
import org.openpdf.pdf.ITextImageElement;
import org.openpdf.pdf.ITextOutputDevice;
import org.openpdf.pdf.RadioButtonFormField;
import org.openpdf.pdf.TextFormField;
import org.openpdf.render.BlockBox;
import org.openpdf.simple.extend.FormSubmissionListener;
import org.w3c.dom.Element;

public class ITextReplacedElementFactory
implements ReplacedElementFactory {
    private final ITextOutputDevice _outputDevice;
    private final Map<Element, RadioButtonFormField> _radioButtonsByElem = new HashMap<Element, RadioButtonFormField>();
    private final Map<String, List<RadioButtonFormField>> _radioButtonsByName = new HashMap<String, List<RadioButtonFormField>>();

    public ITextReplacedElementFactory(ITextOutputDevice outputDevice) {
        this._outputDevice = outputDevice;
    }

    @Override
    public @Nullable ReplacedElement createReplacedElement(LayoutContext c, BlockBox box, UserAgentCallback uac, int cssWidth, int cssHeight) {
        String nodeName;
        Element e = box.getElement();
        if (e == null) {
            return null;
        }
        switch (nodeName = e.getNodeName()) {
            case "img": {
                FSImage fsImage;
                String srcAttr = e.getAttribute("src");
                if (srcAttr.isEmpty() || (fsImage = uac.getImageResource(srcAttr).getImage()) == null) break;
                if (cssWidth != -1 || cssHeight != -1) {
                    fsImage = fsImage.scale(cssWidth, cssHeight);
                }
                return new ITextImageElement(fsImage);
            }
            case "input": {
                String type;
                switch (type = e.getAttribute("type")) {
                    case "hidden": {
                        return new EmptyReplacedElement(1, 1);
                    }
                    case "checkbox": {
                        return new CheckboxFormField(c, box, cssWidth, cssHeight);
                    }
                    case "radio": {
                        RadioButtonFormField result = new RadioButtonFormField(this, c, box, cssWidth, cssHeight);
                        this.saveResult(e, result);
                        return result;
                    }
                }
                return new TextFormField(c, box, cssWidth, cssHeight);
            }
            case "bookmark": {
                if (e.hasAttribute("name")) {
                    String name = e.getAttribute("name");
                    c.addBoxId(name, box);
                    return new BookmarkElement(name);
                }
                return new BookmarkElement(null);
            }
        }
        return null;
    }

    private void saveResult(Element e, RadioButtonFormField result) {
        this._radioButtonsByElem.put(e, result);
        String fieldName = result.getFieldName(this._outputDevice, e);
        List fields = this._radioButtonsByName.computeIfAbsent(fieldName, k -> new ArrayList());
        fields.add(result);
    }

    @Override
    public void reset() {
        this._radioButtonsByElem.clear();
        this._radioButtonsByName.clear();
    }

    @Override
    public void remove(Element e) {
        String fieldName;
        List<RadioButtonFormField> values;
        RadioButtonFormField field = this._radioButtonsByElem.remove(e);
        if (field != null && (values = this._radioButtonsByName.get(fieldName = field.getFieldName(this._outputDevice, e))) != null) {
            values.remove(field);
            if (values.isEmpty()) {
                this._radioButtonsByName.remove(fieldName);
            }
        }
    }

    public void remove(String fieldName) {
        List<RadioButtonFormField> values = this._radioButtonsByName.get(fieldName);
        if (values != null) {
            for (RadioButtonFormField field : values) {
                this._radioButtonsByElem.remove(field.getBox().getElement());
            }
        }
        this._radioButtonsByName.remove(fieldName);
    }

    public @Nullable List<RadioButtonFormField> getRadioButtons(String name) {
        return this._radioButtonsByName.get(name);
    }

    @Override
    public void setFormSubmissionListener(FormSubmissionListener listener) {
    }
}

