/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.layout;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openpdf.css.style.CssContext;
import org.openpdf.layout.BlockFormattingContext;
import org.openpdf.layout.Layer;
import org.openpdf.layout.LayoutContext;
import org.openpdf.render.BlockBox;
import org.openpdf.render.Box;
import org.openpdf.render.LineBox;

public class FloatManager {
    private final List<BoxOffset> _leftFloats = new ArrayList<BoxOffset>();
    private final List<BoxOffset> _rightFloats = new ArrayList<BoxOffset>();
    private final Box _master;

    public FloatManager(Box master) {
        this._master = master;
    }

    public void floatBox(LayoutContext c, Layer layer, BlockFormattingContext bfc, BlockBox box) {
        if (box.getStyle().isFloatedLeft()) {
            this.position(c, bfc, box, Direction.LEFT);
            this.save(box, layer, bfc, Direction.LEFT);
        } else if (box.getStyle().isFloatedRight()) {
            this.position(c, bfc, box, Direction.RIGHT);
            this.save(box, layer, bfc, Direction.RIGHT);
        }
    }

    public void clear(CssContext cssCtx, BlockFormattingContext bfc, Box box) {
        if (box.getStyle().isClearLeft()) {
            this.moveClear(cssCtx, bfc, box, this.getFloats(Direction.LEFT));
        }
        if (box.getStyle().isClearRight()) {
            this.moveClear(cssCtx, bfc, box, this.getFloats(Direction.RIGHT));
        }
    }

    private void save(BlockBox current, Layer layer, BlockFormattingContext bfc, Direction direction) {
        Point p = bfc.getOffset();
        this.getFloats(direction).add(new BoxOffset(current, p.x, p.y));
        layer.addFloat(current);
        current.getFloatedBoxData().setManager(this);
        current.calcCanvasLocation();
        current.calcChildLocations();
    }

    private void position(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, Direction direction) {
        this.moveAllTheWayOver(current, direction);
        this.alignToLastOpposingFloat(cssCtx, bfc, current, direction);
        this.alignToLastFloat(cssCtx, bfc, current, direction);
        if (!this.fitsInContainingBlock(current) || this.overlaps(cssCtx, bfc, current, this.getFloats(direction))) {
            this.moveAllTheWayOver(current, direction);
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
        }
        if (this.overlaps(cssCtx, bfc, current, this.getOpposingFloats(direction))) {
            this.moveAllTheWayOver(current, direction);
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
            this.moveFloatBelow(cssCtx, bfc, current, this.getOpposingFloats(direction));
        }
        if (current.getStyle().isCleared()) {
            if (current.getStyle().isClearLeft() && direction == Direction.LEFT) {
                this.moveAllTheWayOver(current, Direction.LEFT);
            } else if (current.getStyle().isClearRight() && direction == Direction.RIGHT) {
                this.moveAllTheWayOver(current, Direction.RIGHT);
            }
            this.moveFloatBelow(cssCtx, bfc, current, this.getFloats(direction));
        }
    }

    private List<BoxOffset> getFloats(Direction direction) {
        return direction == Direction.LEFT ? this._leftFloats : this._rightFloats;
    }

    private List<BoxOffset> getOpposingFloats(Direction direction) {
        return direction == Direction.LEFT ? this._rightFloats : this._leftFloats;
    }

    private void alignToLastFloat(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, Direction direction) {
        List<BoxOffset> floats = this.getFloats(direction);
        if (!floats.isEmpty()) {
            Point offset = bfc.getOffset();
            BoxOffset lastOffset = floats.get(floats.size() - 1);
            BlockBox last = lastOffset.box();
            Rectangle currentBounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
            Rectangle lastBounds = last.getMarginEdge(cssCtx, -lastOffset.x(), -lastOffset.y());
            boolean moveOver = false;
            if (currentBounds.y < lastBounds.y) {
                currentBounds.translate(0, lastBounds.y - currentBounds.y);
                moveOver = true;
            }
            if (currentBounds.y >= lastBounds.y && currentBounds.y < lastBounds.y + lastBounds.height) {
                moveOver = true;
            }
            if (moveOver) {
                if (direction == Direction.LEFT) {
                    currentBounds.x = lastBounds.x + last.getWidth();
                } else if (direction == Direction.RIGHT) {
                    currentBounds.x = lastBounds.x - current.getWidth();
                }
                currentBounds.translate(offset.x, offset.y);
                current.setX(currentBounds.x);
                current.setY(currentBounds.y);
            }
        }
    }

    private void alignToLastOpposingFloat(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, Direction direction) {
        List<BoxOffset> floats = this.getOpposingFloats(direction);
        if (!floats.isEmpty()) {
            Point offset = bfc.getOffset();
            BoxOffset lastOffset = floats.get(floats.size() - 1);
            Rectangle currentBounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
            Rectangle lastBounds = lastOffset.box().getMarginEdge(cssCtx, -lastOffset.x(), -lastOffset.y());
            if (currentBounds.y < lastBounds.y) {
                currentBounds.translate(0, lastBounds.y - currentBounds.y);
                currentBounds.translate(offset.x, offset.y);
                current.setY(currentBounds.y);
            }
        }
    }

    private void moveAllTheWayOver(BlockBox current, Direction direction) {
        if (direction == Direction.LEFT) {
            current.setX(0);
        } else if (direction == Direction.RIGHT) {
            current.setX(current.getContainingBlock().getContentWidth() - current.getWidth());
        }
    }

    private boolean fitsInContainingBlock(BlockBox current) {
        return current.getX() >= 0 && current.getX() + current.getWidth() <= current.getContainingBlock().getContentWidth();
    }

    private int findLowestY(CssContext cssCtx, List<BoxOffset> floats) {
        int result = 0;
        for (BoxOffset floater : floats) {
            Rectangle bounds = floater.box().getMarginEdge(cssCtx, -floater.x(), -floater.y());
            if (bounds.y + bounds.height <= result) continue;
            result = bounds.y + bounds.height;
        }
        return result;
    }

    public int getClearDelta(CssContext cssCtx, int bfcRelativeY) {
        int lowestLeftY = this.findLowestY(cssCtx, this.getFloats(Direction.LEFT));
        int lowestRightY = this.findLowestY(cssCtx, this.getFloats(Direction.RIGHT));
        int lowestY = Math.max(lowestLeftY, lowestRightY);
        return lowestY - bfcRelativeY;
    }

    private boolean overlaps(CssContext cssCtx, BlockFormattingContext bfc, BlockBox current, List<BoxOffset> floats) {
        Point offset = bfc.getOffset();
        Rectangle bounds = current.getMarginEdge(cssCtx, -offset.x, -offset.y);
        for (BoxOffset floater : floats) {
            Rectangle floaterBounds = floater.box().getMarginEdge(cssCtx, -floater.x(), -floater.y());
            if (!floaterBounds.intersects(bounds)) continue;
            return true;
        }
        return false;
    }

    private void moveFloatBelow(CssContext cssCtx, BlockFormattingContext bfc, Box current, List<BoxOffset> floats) {
        if (floats.isEmpty()) {
            return;
        }
        Point offset = bfc.getOffset();
        int boxY = current.getY() - offset.y;
        int floatY = this.findLowestY(cssCtx, floats);
        if (floatY - boxY > 0) {
            current.setY(current.getY() + (floatY - boxY));
        }
    }

    private void moveClear(CssContext cssCtx, BlockFormattingContext bfc, Box current, List<BoxOffset> floats) {
        if (floats.isEmpty()) {
            return;
        }
        Point offset = bfc.getOffset();
        Rectangle bounds = current.getBorderEdge(current.getX() - offset.x, current.getY() - offset.y, cssCtx);
        int y = this.findLowestY(cssCtx, floats);
        if (bounds.y < y) {
            bounds.y = y;
            bounds.translate(offset.x, offset.y);
            current.setY(bounds.y - (int)current.getMargin(cssCtx).top());
        }
    }

    public void removeFloat(BlockBox floater) {
        this.removeFloat(floater, this.getFloats(Direction.LEFT));
        this.removeFloat(floater, this.getFloats(Direction.RIGHT));
    }

    private void removeFloat(BlockBox floater, List<BoxOffset> floats) {
        Iterator<BoxOffset> i = floats.iterator();
        while (i.hasNext()) {
            BoxOffset boxOffset = i.next();
            if (!boxOffset.box().equals(floater)) continue;
            i.remove();
            floater.getFloatedBoxData().setManager(null);
        }
    }

    public void calcFloatLocations() {
        this.calcFloatLocations(this.getFloats(Direction.LEFT));
        this.calcFloatLocations(this.getFloats(Direction.RIGHT));
    }

    private void calcFloatLocations(List<BoxOffset> floats) {
        for (BoxOffset boxOffset : floats) {
            boxOffset.box().calcCanvasLocation();
            boxOffset.box().calcChildLocations();
        }
    }

    private void applyLineHeightHack(CssContext cssCtx, Box line, Rectangle bounds) {
        if (line.getHeight() == 0) {
            bounds.height = (int)line.getStyle().getLineHeight(cssCtx);
        }
    }

    public int getNextLineBoxDelta(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        BoxDistance left = this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this._leftFloats, Direction.LEFT);
        BoxDistance right = this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this._rightFloats, Direction.RIGHT);
        int leftDelta = left.box() != null ? this.calcDelta(cssCtx, line, left) : 0;
        int rightDelta = right.box() != null ? this.calcDelta(cssCtx, line, right) : 0;
        return Math.max(leftDelta, rightDelta);
    }

    private int calcDelta(CssContext cssCtx, LineBox line, BoxDistance boxDistance) {
        BlockBox floated = boxDistance.box();
        Rectangle rect = floated.getBorderEdge(floated.getAbsX(), floated.getAbsY(), cssCtx);
        int bottom = rect.y + rect.height;
        return bottom - line.getAbsY();
    }

    public int getLeftFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        return this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this._leftFloats, Direction.LEFT).distance();
    }

    public int getRightFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth) {
        return this.getFloatDistance(cssCtx, bfc, line, containingBlockContentWidth, this._rightFloats, Direction.RIGHT).distance();
    }

    private BoxDistance getFloatDistance(CssContext cssCtx, BlockFormattingContext bfc, LineBox line, int containingBlockContentWidth, List<BoxOffset> floatsList, Direction direction) {
        if (floatsList.isEmpty()) {
            return new BoxDistance(null, 0);
        }
        Point offset = bfc.getOffset();
        Rectangle lineBounds = line.getMarginEdge(cssCtx, -offset.x, -offset.y);
        lineBounds.width = containingBlockContentWidth;
        int farthestOver = direction == Direction.LEFT ? lineBounds.x : lineBounds.x + lineBounds.width;
        this.applyLineHeightHack(cssCtx, line, lineBounds);
        BlockBox farthestOverBox = null;
        for (BoxOffset floater : floatsList) {
            Rectangle fr = floater.box().getMarginEdge(cssCtx, -floater.x(), -floater.y());
            if (!lineBounds.intersects(fr)) continue;
            if (direction == Direction.LEFT && fr.x + fr.width > farthestOver) {
                farthestOver = fr.x + fr.width;
            } else if (direction == Direction.RIGHT && fr.x < farthestOver) {
                farthestOver = fr.x;
            }
            farthestOverBox = floater.box();
        }
        if (direction == Direction.LEFT) {
            return new BoxDistance(farthestOverBox, farthestOver - lineBounds.x);
        }
        return new BoxDistance(farthestOverBox, lineBounds.x + lineBounds.width - farthestOver);
    }

    public Box getMaster() {
        return this._master;
    }

    public Point getOffset(BlockBox floater) {
        return this.getOffset(floater, floater.getStyle().isFloatedLeft() ? this.getFloats(Direction.LEFT) : this.getFloats(Direction.RIGHT));
    }

    @CheckReturnValue
    private @Nullable Point getOffset(BlockBox floater, List<BoxOffset> floats) {
        for (BoxOffset boxOffset : floats) {
            BlockBox box = boxOffset.box();
            if (!box.equals(floater)) continue;
            return new Point(boxOffset.x(), boxOffset.y());
        }
        return null;
    }

    private void performFloatOperation(FloatOperation op, List<BoxOffset> floats) {
        for (BoxOffset boxOffset : floats) {
            BlockBox box = boxOffset.box();
            box.setAbsX(box.getX() + this.getMaster().getAbsX() - boxOffset.x());
            box.setAbsY(box.getY() + this.getMaster().getAbsY() - boxOffset.y());
            op.operate(box);
        }
    }

    public void performFloatOperation(FloatOperation op) {
        this.performFloatOperation(op, this.getFloats(Direction.LEFT));
        this.performFloatOperation(op, this.getFloats(Direction.RIGHT));
    }

    static enum Direction {
        LEFT,
        RIGHT;

    }

    private record BoxOffset(BlockBox box, int x, int y) {
    }

    private record BoxDistance(@Nullable BlockBox box, int distance) {
    }

    public static interface FloatOperation {
        public void operate(Box var1);
    }
}

