/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.swing;

import com.google.errorprone.annotations.CheckReturnValue;
import java.awt.Image;
import java.awt.image.BufferedImage;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.openpdf.extend.FSImage;
import org.openpdf.util.ImageUtil;

public abstract class AWTFSImage
implements FSImage {
    private static final FSImage NULL_FS_IMAGE = new NullImage();

    @CheckReturnValue
    public static FSImage createImage(@Nullable Image img) {
        if (img == null) {
            return NULL_FS_IMAGE;
        }
        BufferedImage bufferedImage = ImageUtil.convertToBufferedImage(img, 2);
        return new NewAWTFSImage(bufferedImage);
    }

    protected AWTFSImage() {
    }

    public abstract BufferedImage getImage();

    static class NewAWTFSImage
    extends AWTFSImage {
        private final BufferedImage img;

        public NewAWTFSImage(BufferedImage img) {
            this.img = img;
        }

        @Override
        public int getWidth() {
            return this.img.getWidth(null);
        }

        @Override
        public int getHeight() {
            return this.img.getHeight(null);
        }

        @Override
        public BufferedImage getImage() {
            return this.img;
        }

        @Override
        @CheckReturnValue
        public @NonNull FSImage scale(int width, int height) {
            if (width > 0 || height > 0) {
                int currentWith = this.getWidth();
                int currentHeight = this.getHeight();
                int targetWidth = width;
                int targetHeight = height;
                if (targetWidth == -1) {
                    targetWidth = (int)((double)currentWith * ((double)targetHeight / (double)currentHeight));
                }
                if (targetHeight == -1) {
                    targetHeight = (int)((double)currentHeight * ((double)targetWidth / (double)currentWith));
                }
                if (currentWith != targetWidth || currentHeight != targetHeight) {
                    return new NewAWTFSImage(ImageUtil.getScaledInstance(this.img, targetWidth, targetHeight));
                }
            }
            return this;
        }
    }

    private static final class NullImage
    extends AWTFSImage {
        private static final BufferedImage EMPTY_IMAGE = ImageUtil.createTransparentImage(1, 1);

        private NullImage() {
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        @CheckReturnValue
        public @NonNull FSImage scale(int width, int height) {
            return this;
        }

        @Override
        public BufferedImage getImage() {
            return EMPTY_IMAGE;
        }
    }
}

