/*
 * Decompiled with CFR 0.152.
 */
package org.openpdf.simple;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.jspecify.annotations.Nullable;
import org.openpdf.layout.SharedContext;
import org.openpdf.simple.XHTMLPanel;
import org.openpdf.util.ImageUtil;
import org.w3c.dom.Document;

public final class Graphics2DRenderer {
    private final XHTMLPanel panel = new XHTMLPanel();

    public Graphics2DRenderer(String url) {
        this.panel.setInteractive(false);
        this.panel.setDocument(url);
    }

    public Graphics2DRenderer(Document doc, String base_url) {
        this.panel.setInteractive(false);
        this.panel.setDocument(doc, base_url);
    }

    public void layout(Graphics2D g2, @Nullable Dimension dim) {
        if (dim != null) {
            this.panel.setSize(dim);
        }
        this.panel.doDocumentLayout(g2);
    }

    public void render(Graphics2D g2) {
        if (g2.getClip() == null) {
            g2.setClip(this.getMinimumSize());
        }
        this.panel.paintComponent(g2);
    }

    public Rectangle getMinimumSize() {
        if (this.panel.getPreferredSize() != null) {
            return new Rectangle(0, 0, (int)this.panel.getPreferredSize().getWidth(), (int)this.panel.getPreferredSize().getHeight());
        }
        return new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public SharedContext getSharedContext() {
        return this.panel.getSharedContext();
    }

    public XHTMLPanel getPanel() {
        return this.panel;
    }

    public static BufferedImage renderToImage(String url, int width, int height) {
        return Graphics2DRenderer.renderToImage(url, width, height, 2);
    }

    public static BufferedImage renderToImage(String url, int width, int height, int bufferedImageType) {
        Graphics2DRenderer g2r = new Graphics2DRenderer(url);
        Dimension dim = new Dimension(width, height);
        BufferedImage buff = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), bufferedImageType);
        ImageUtil.withGraphics(buff, g -> {
            g2r.layout((Graphics2D)g, dim);
            g2r.render((Graphics2D)g);
        });
        return buff;
    }

    public static BufferedImage renderToImageAutoSize(String url, int width) {
        return Graphics2DRenderer.renderToImageAutoSize(url, width, 2);
    }

    public static BufferedImage renderToImageAutoSize(String url, int width, int bufferedImageType) {
        Graphics2DRenderer g2r = new Graphics2DRenderer(url);
        Dimension dim = new Dimension(width, 1000);
        BufferedImage tempBuffer = new BufferedImage((int)dim.getWidth(), (int)dim.getHeight(), bufferedImageType);
        ImageUtil.withGraphics(tempBuffer, g -> g2r.layout((Graphics2D)g, new Dimension(width, 1000)));
        Rectangle rect = g2r.getMinimumSize();
        BufferedImage buff = new BufferedImage((int)rect.getWidth(), (int)rect.getHeight(), bufferedImageType);
        ImageUtil.withGraphics(buff, g -> g2r.render((Graphics2D)g));
        return buff;
    }
}

