/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.style;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;

public final class TextAlignStyle {
    public static final String TEXT_ALIGN = "text-align";
    public static final String VERTICAL_ALIGN = "vertical-align";
    public static final String MIDDLE = "middle";
    private static final Map<String, HorizontalAlignment> horizontalAlignmentMap = Arrays.stream(HorizontalAlignment.values()).collect(Collectors.toMap(h -> h.name().toLowerCase(), h -> h));
    private static final Map<String, VerticalAlignment> verticalAlignmentMap = Arrays.stream(VerticalAlignment.values()).collect(Collectors.toMap(v -> v.name().toLowerCase(), v -> v));

    public static void setTextAlign(CellStyle cellStyle, Map<String, String> tdStyle) {
        String verticalAlign;
        String textAlign = tdStyle.get(TEXT_ALIGN);
        if (horizontalAlignmentMap.containsKey(textAlign)) {
            cellStyle.setAlignment(horizontalAlignmentMap.get(textAlign));
        }
        if (verticalAlignmentMap.containsKey(verticalAlign = tdStyle.get(VERTICAL_ALIGN))) {
            cellStyle.setVerticalAlignment(verticalAlignmentMap.get(verticalAlign));
        }
    }

    static {
        verticalAlignmentMap.put(MIDDLE, VerticalAlignment.CENTER);
    }
}

