/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.context.ReadContext;
import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.TimeZone;

public class LocalDateTimeReadConverter
extends AbstractReadConverter<LocalDateTime> {
    @Override
    public LocalDateTime doConvert(ReadContext<?> readContext) {
        String v = readContext.getVal();
        if (this.isDateNumber(v)) {
            long time = Long.parseLong(v);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), TimeZone.getDefault().toZoneId());
        }
        if (this.isDateDecimalNumber(v)) {
            long time = this.convertExcelNumberDateToMilli(v);
            return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), TimeZone.getDefault().toZoneId());
        }
        DateTimeFormatter dateTimeFormatter = this.getDateFormatFormatter(readContext);
        return LocalDateTime.parse(v, dateTimeFormatter);
    }
}

