/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.context.ReadContext;
import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DateReadConverter
extends AbstractReadConverter<Date> {
    @Override
    public Date doConvert(ReadContext<?> readContext) {
        String v = readContext.getVal();
        if (this.isDateNumber(v)) {
            long time = Long.parseLong(v);
            return new Date(time);
        }
        if (this.isDateDecimalNumber(v)) {
            long time = this.convertExcelNumberDateToMilli(v);
            return new Date(time);
        }
        String dateFormatPattern = this.getDateFormatPattern(readContext);
        SimpleDateFormat sdf = this.getSimpleDateFormat(dateFormatPattern);
        try {
            return sdf.parse(v);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

