/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelFactory;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.parser.StyleParser;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.exception.ExcelBuildException;
import com.github.liaochong.myexcel.utils.FileExportUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HtmlToExcelStreamFactory
extends AbstractExcelFactory {
    private static final Logger log = LoggerFactory.getLogger(HtmlToExcelStreamFactory.class);
    private static final int XLSX_MAX_ROW_COUNT = 0x100000;
    private static final int XLS_MAX_ROW_COUNT = 65536;
    private static final Tr STOP_FLAG = new Tr(-1, 0);
    private int maxRowCountOfSheet = 0x100000;
    private Sheet sheet;
    private BlockingQueue<Tr> trWaitQueue;
    private boolean stop;
    private volatile boolean exception;
    private long startTime;
    private String sheetName = "Sheet";
    private Map<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>();
    private int rowNum;
    private int sheetNum;
    private int maxColIndex;
    private int capacity;
    private int count;
    private List<Tr> titles;
    private List<Path> tempFilePaths = new ArrayList<Path>();
    private List<CompletableFuture<Void>> futures = new LinkedList<CompletableFuture<Void>>();
    private Consumer<Path> pathConsumer;
    private ExecutorService executorService;
    private boolean fixedTitles;
    private volatile Thread receiveThread;
    private StyleParser styleParser;

    public HtmlToExcelStreamFactory(int waitSize, ExecutorService executorService, Consumer<Path> pathConsumer, int capacity, boolean fixedTitles, StyleParser styleParser) {
        this.trWaitQueue = new LinkedBlockingQueue<Tr>(waitSize);
        this.executorService = executorService;
        this.pathConsumer = pathConsumer;
        this.capacity = capacity;
        this.fixedTitles = fixedTitles;
        this.styleParser = styleParser;
    }

    public void start(Table table, Workbook workbook) {
        log.info("Start build excel");
        if (workbook != null) {
            this.workbook = workbook;
        }
        this.startTime = System.currentTimeMillis();
        if (this.workbook == null) {
            this.workbookType(WorkbookType.SXLSX);
        }
        if (this.isHssf) {
            this.maxRowCountOfSheet = 65536;
        }
        this.initCellStyle(this.workbook);
        if (table != null) {
            this.sheetName = this.getRealSheetName(table.getCaption());
        }
        this.sheet = this.workbook.createSheet(this.sheetName);
        Thread thread = new Thread(this::receive);
        thread.setName("myexcel-exec-" + thread.getId());
        thread.start();
    }

    public void appendTitles(List<Tr> trList) {
        this.titles = trList;
        trList.forEach(this::append);
    }

    public void append(Tr tr) {
        if (this.exception) {
            log.error("Received a termination command,an exception occurred while processing");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (this.stop) {
            log.error("Received a termination command,the build method has been called");
            throw new UnsupportedOperationException("Received a termination command");
        }
        if (tr == null) {
            log.warn("This tr is null and will be discarded");
            return;
        }
        this.putTrToQueue(tr);
    }

    private void receive() {
        try {
            this.receiveThread = Thread.currentThread();
            Tr tr = this.getTrFromQueue();
            if (this.maxColIndex == 0) {
                int tdSize = tr.getTdList().size();
                this.maxColIndex = tdSize > 0 ? tdSize - 1 : 0;
            }
            int totalSize = 0;
            while (tr != STOP_FLAG) {
                if (this.capacity > 0 && this.count == this.capacity) {
                    this.storeToTempFile();
                    this.initNewWorkbook();
                }
                if (this.rowNum == this.maxRowCountOfSheet) {
                    ++this.sheetNum;
                    this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
                    this.colWidthMap = new HashMap<Integer, Integer>();
                    this.sheet = this.workbook.createSheet(this.sheetName + " (" + this.sheetNum + ")");
                    this.rowNum = 0;
                    this.setTitles();
                }
                this.setTdStyle(tr);
                this.appendRow(tr);
                ++totalSize;
                tr.getColWidthMap().forEach((k, v) -> {
                    Integer val = this.colWidthMap.get(k);
                    if (val == null || v > val) {
                        this.colWidthMap.put((Integer)k, (Integer)v);
                    }
                });
                tr = this.getTrFromQueue();
            }
            log.info("Total size:{}", (Object)totalSize);
        }
        catch (Exception e) {
            this.exception = true;
            this.trWaitQueue.clear();
            this.trWaitQueue = null;
            this.clear();
            log.error("An exception occurred while processing", (Throwable)e);
            throw new ExcelBuildException("An exception occurred while processing", e);
        }
    }

    private void setTdStyle(Tr tr) {
        if (tr.isFromTemplate()) {
            return;
        }
        this.styleParser.toggle();
        int size = tr.getTdList().size();
        for (int i = 0; i < size; ++i) {
            Td td = tr.getTdList().get(i);
            if (td.isTh()) {
                td.setStyle(this.styleParser.getTitleStyle("title&" + td.getCol()));
                continue;
            }
            td.setStyle(this.styleParser.getCellStyle(i, td.getTdContentType(), td.getFormat()));
        }
    }

    private Tr getTrFromQueue() throws InterruptedException {
        Tr tr = this.trWaitQueue.poll(1L, TimeUnit.HOURS);
        if (tr == null) {
            throw new IllegalStateException("Get tr failure,timeout 1 hour.");
        }
        return tr;
    }

    @Override
    public Workbook build() {
        this.waiting();
        this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
        this.freezeTitles(this.workbook);
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.workbook;
    }

    List<Path> buildAsPaths() {
        this.waiting();
        this.storeToTempFile();
        if (this.futures != null) {
            this.futures.forEach(CompletableFuture::join);
        }
        log.info("Build Excel success,takes {} ms", (Object)(System.currentTimeMillis() - this.startTime));
        return this.tempFilePaths.stream().filter(path -> Objects.nonNull(path) && path.toFile().exists()).collect(Collectors.toList());
    }

    protected void waiting() {
        if (this.exception) {
            throw new IllegalStateException("An exception occurred while processing");
        }
        this.stop = true;
        this.putTrToQueue(STOP_FLAG);
        while (!this.trWaitQueue.isEmpty()) {
            if (!this.exception) continue;
            throw new IllegalThreadStateException("An exception occurred while processing");
        }
    }

    private void putTrToQueue(Tr tr) {
        try {
            boolean putSuccess = this.trWaitQueue.offer(tr, 1L, TimeUnit.HOURS);
            if (!putSuccess) {
                throw new IllegalStateException("Put tr to queue failure,timeout 1 hour.");
            }
        }
        catch (InterruptedException e) {
            if (this.receiveThread != null) {
                this.receiveThread.interrupt();
            }
            throw new ExcelBuildException("Put tr to queue failure", e);
        }
    }

    private void storeToTempFile() {
        String suffix = this.isHssf ? ".xls" : ".xlsx";
        Path path = TempFileOperator.createTempFile("s_t_r_p", suffix);
        this.tempFilePaths.add(path);
        try {
            if (this.executorService != null) {
                Workbook tempWorkbook = this.workbook;
                Sheet tempSheet = this.sheet;
                Map<Integer, Integer> tempColWidthMap = this.colWidthMap;
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> {
                    this.setColWidth(tempColWidthMap, tempSheet, this.maxColIndex);
                    this.freezeTitles(tempWorkbook);
                    try {
                        FileExportUtil.export(tempWorkbook, path.toFile());
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    if (this.pathConsumer != null) {
                        this.pathConsumer.accept(path);
                    }
                }, this.executorService);
                this.futures.add(future);
            } else {
                this.setColWidth(this.colWidthMap, this.sheet, this.maxColIndex);
                this.freezeTitles(this.workbook);
                FileExportUtil.export(this.workbook, path.toFile());
                if (Objects.nonNull(this.pathConsumer)) {
                    this.pathConsumer.accept(path);
                }
            }
        }
        catch (IOException e) {
            this.clear();
            throw new RuntimeException(e);
        }
    }

    private void freezeTitles(Workbook workbook) {
        if (this.fixedTitles && this.titles != null) {
            int size = workbook.getNumberOfSheets();
            for (int i = 0; i < size; ++i) {
                workbook.getSheetAt(i).createFreezePane(0, this.titles.size());
            }
        }
    }

    private void initNewWorkbook() {
        this.workbook = null;
        this.workbookType(this.isHssf ? WorkbookType.XLS : WorkbookType.SXLSX);
        this.sheetNum = 0;
        this.rowNum = 0;
        this.count = 0;
        this.colWidthMap = new HashMap<Integer, Integer>();
        this.clearCache();
        this.initCellStyle(this.workbook);
        this.sheet = this.workbook.createSheet(this.sheetName);
        if (this.titles == null) {
            return;
        }
        this.setTitles();
    }

    private void setTitles() {
        for (Tr titleTr : this.titles) {
            this.appendRow(titleTr);
        }
    }

    private void appendRow(Tr tr) {
        tr.setIndex(this.rowNum);
        tr.getTdList().forEach(td -> td.setRow(this.rowNum));
        ++this.rowNum;
        ++this.count;
        this.createRow(tr, this.sheet);
    }

    Path buildAsZip(String fileName) {
        this.waiting();
        this.storeToTempFile();
        if (Objects.nonNull(this.futures)) {
            this.futures.forEach(CompletableFuture::join);
        }
        String suffix = this.isHssf ? ".xls" : ".xlsx";
        Path zipFile = TempFileOperator.createTempFile(fileName, ".zip");
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));){
            int size = this.tempFilePaths.size();
            for (int i = 1; i <= size; ++i) {
                Path path = this.tempFilePaths.get(i - 1);
                ZipEntry zipEntry = new ZipEntry(fileName + " (" + i + ")" + suffix);
                out.putNextEntry(zipEntry);
                out.write(Files.readAllBytes(path));
                out.closeEntry();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.clear();
            this.tempFilePaths.clear();
        }
        this.tempFilePaths.add(zipFile);
        return zipFile;
    }

    public void cancel() {
        this.waiting();
        this.clear();
    }

    public void clear() {
        this.closeWorkbook();
        TempFileOperator.deleteTempFiles(this.tempFilePaths);
    }
}

