/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.DefaultStreamExcelBuilder;
import com.github.liaochong.myexcel.core.WorkbookType;
import com.github.liaochong.myexcel.core.strategy.AutoWidthStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelBuilder<T>
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelBuilder.class);
    private static final String STYLE_COMMON_TD = "border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;";
    private static final String STYLE_TITLE = "font-weight:bold;font-size:14;text-align:center;vertical-align:middle;";
    private DefaultStreamExcelBuilder<T> streamExcelBuilder;

    private DefaultExcelBuilder(DefaultStreamExcelBuilder<T> streamExcelBuilder) {
        streamExcelBuilder.widthStrategy(WidthStrategy.COMPUTE_AUTO_WIDTH);
        streamExcelBuilder.style("title->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;font-weight:bold;font-size:14;text-align:center;vertical-align:middle;", "even->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;", "odd->border-top-style:thin;border-right-style:thin;border-bottom-style:thin;border-left-style:thin;background-color:#f6f8fa;");
        this.streamExcelBuilder = streamExcelBuilder;
    }

    public static <T> DefaultExcelBuilder<T> of(@NonNull Class<T> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DefaultExcelBuilder<T> defaultExcelBuilder = new DefaultExcelBuilder<T>(DefaultStreamExcelBuilder.of(dataType));
        defaultExcelBuilder.streamExcelBuilder.workbookType(WorkbookType.XLSX);
        return defaultExcelBuilder;
    }

    public static <T> DefaultExcelBuilder<T> of(@NonNull Class<T> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        return new DefaultExcelBuilder<T>(DefaultStreamExcelBuilder.of(dataType, workbook));
    }

    @Deprecated
    public static DefaultExcelBuilder<Map> getInstance() {
        DefaultExcelBuilder<Map> defaultExcelBuilder = new DefaultExcelBuilder<Map>(DefaultStreamExcelBuilder.getInstance());
        defaultExcelBuilder.streamExcelBuilder.workbookType(WorkbookType.XLSX);
        return defaultExcelBuilder;
    }

    @Deprecated
    public static DefaultExcelBuilder<Map> getInstance(Workbook workbook) {
        return new DefaultExcelBuilder<Map>(DefaultStreamExcelBuilder.getInstance(workbook));
    }

    public DefaultExcelBuilder<T> titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.streamExcelBuilder.titles(titles);
        return this;
    }

    public DefaultExcelBuilder<T> sheetName(@NonNull String sheetName) {
        if (sheetName == null) {
            throw new NullPointerException("sheetName is marked non-null but is null");
        }
        this.streamExcelBuilder.sheetName(sheetName);
        return this;
    }

    public DefaultExcelBuilder<T> fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.streamExcelBuilder.fieldDisplayOrder(fieldDisplayOrder);
        return this;
    }

    public DefaultExcelBuilder<T> workbookType(@NonNull WorkbookType workbookType) {
        if (workbookType == null) {
            throw new NullPointerException("workbookType is marked non-null but is null");
        }
        this.streamExcelBuilder.workbookType(workbookType);
        return this;
    }

    public DefaultExcelBuilder<T> noStyle() {
        this.streamExcelBuilder.noStyle();
        return this;
    }

    public DefaultExcelBuilder<T> widthStrategy(WidthStrategy widthStrategy) {
        this.streamExcelBuilder.widthStrategy(widthStrategy);
        return this;
    }

    @Deprecated
    public DefaultExcelBuilder<T> autoWidthStrategy(@NonNull AutoWidthStrategy autoWidthStrategy) {
        if (autoWidthStrategy == null) {
            throw new NullPointerException("autoWidthStrategy is marked non-null but is null");
        }
        this.streamExcelBuilder.autoWidthStrategy(autoWidthStrategy);
        return this;
    }

    public DefaultExcelBuilder<T> fixedTitles() {
        this.streamExcelBuilder.fixedTitles();
        return this;
    }

    public DefaultExcelBuilder<T> widths(int ... widths) {
        this.streamExcelBuilder.widths(widths);
        return this;
    }

    public DefaultExcelBuilder<T> width(int columnIndex, int width) {
        this.streamExcelBuilder.width(columnIndex, width);
        return this;
    }

    public DefaultExcelBuilder<T> hideColumns(int ... columnIndexs) {
        this.streamExcelBuilder.hideColumns(columnIndexs);
        return this;
    }

    public DefaultExcelBuilder<T> groups(Class<?> ... groups) {
        this.streamExcelBuilder.groups((Class[])groups);
        return this;
    }

    @Deprecated
    public DefaultExcelBuilder<T> globalStyle(String ... styles) {
        return this.style(styles);
    }

    public DefaultExcelBuilder<T> style(String ... styles) {
        this.streamExcelBuilder.style(styles);
        return this;
    }

    public Workbook build(List<T> data) {
        try {
            this.streamExcelBuilder.start();
            this.streamExcelBuilder.append(data);
            return this.streamExcelBuilder.build();
        }
        catch (Exception e) {
            try {
                this.streamExcelBuilder.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.streamExcelBuilder != null) {
            this.streamExcelBuilder.close();
        }
    }
}

