/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.Csv;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.CsvBuildException;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.TempFileOperator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public class CsvBuilder<T>
extends AbstractSimpleExcelBuilder
implements Closeable {
    private static final Pattern PATTERN_QUOTES_PREMISE = Pattern.compile("[,\"]+");
    private static final Pattern PATTERN_QUOTES = Pattern.compile("\"");
    private volatile Csv csv;

    private CsvBuilder() {
        super(true);
    }

    public static <T> CsvBuilder<T> of(Class<T> clazz) {
        CsvBuilder<T> csvBuilder = new CsvBuilder<T>();
        boolean bl = csvBuilder.isMapBuild = clazz == Map.class;
        if (!csvBuilder.isMapBuild) {
            ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(clazz);
            csvBuilder.filteredFields = csvBuilder.getFilteredFields(classFieldContainer, new Class[0]);
        }
        return csvBuilder;
    }

    public CsvBuilder<T> groups(Class<?> ... groups) {
        this.filteredFields = this.getGroupFields(this.filteredFields, groups);
        return this;
    }

    public CsvBuilder<T> fieldDisplayOrder(@NonNull List<String> fieldDisplayOrder) {
        if (fieldDisplayOrder == null) {
            throw new NullPointerException("fieldDisplayOrder is marked non-null but is null");
        }
        this.fieldDisplayOrder = fieldDisplayOrder;
        return this;
    }

    public CsvBuilder<T> titles(@NonNull List<String> titles) {
        if (titles == null) {
            throw new NullPointerException("titles is marked non-null but is null");
        }
        this.titles = titles;
        return this;
    }

    public CsvBuilder<T> noTitles() {
        this.titles = null;
        return this;
    }

    public Csv build(List<T> beans) {
        return this.doWrite(beans);
    }

    public void append(List<T> beans) {
        this.doWrite(beans);
    }

    public Csv build() {
        return this.csv;
    }

    private Csv doWrite(List<T> beans) {
        try {
            if (beans == null || beans.isEmpty()) {
                return this.csv;
            }
            List<List<?>> contents = this.getRenderContent(beans);
            this.writeToCsv(contents);
        }
        catch (Exception e) {
            if (this.csv != null) {
                TempFileOperator.deleteTempFile(this.csv.getFilePath());
            }
            throw new CsvBuildException("Build csv failure", e);
        }
        return this.csv;
    }

    private List<List<?>> getRenderContent(List<T> data) {
        LinkedList result = new LinkedList();
        for (T datum : data) {
            List<Pair<Class, ?>> resolvedDataList = this.isMapBuild ? this.assemblingMapContents((Map)datum) : this.getRenderContent(datum, this.filteredFields);
            List values = resolvedDataList.stream().map(Pair::getValue).collect(Collectors.toList());
            result.add(values);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCsv(List<List<?>> data) {
        if (this.titles != null) {
            CsvBuilder csvBuilder = this;
            synchronized (csvBuilder) {
                if (this.titles == null) {
                    return;
                }
                data.add(0, this.titles);
                this.titles = null;
            }
        }
        List content = data.stream().map(d -> d.stream().map(v -> {
            if (v == null) {
                return "";
            }
            String vStr = v.toString();
            vStr = PATTERN_QUOTES.matcher(vStr).replaceAll("\"\"");
            boolean hasComma = PATTERN_QUOTES_PREMISE.matcher(v.toString()).find();
            if (hasComma) {
                vStr = "\"" + vStr + "\"";
            }
            return vStr;
        }).collect(Collectors.joining(","))).collect(Collectors.toCollection(LinkedList::new));
        CsvBuilder csvBuilder = this;
        synchronized (csvBuilder) {
            try {
                if (this.csv == null) {
                    Path csvTemp = TempFileOperator.createTempFile("d_t_c", ".csv");
                    this.csv = new Csv(csvTemp);
                }
                Files.write(this.csv.getFilePath(), (Iterable<? extends CharSequence>)content, StandardCharsets.UTF_8, StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }

    public void clear() {
        if (this.csv != null) {
            this.csv.clear();
        }
    }
}

