/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Properties;

public class MappingWriteConverter
implements WriteConverter {
    private WeakCache<String, Pair<Class, Object>> mappingCache = new WeakCache();

    @Override
    public boolean support(Field field, Object fieldVal) {
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        return excelColumn != null && StringUtil.isNotBlank(excelColumn.mapping());
    }

    @Override
    public Pair<Class, Object> convert(Field field, Object fieldVal) {
        ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
        String cacheKey = excelColumn.mapping() + "->" + fieldVal;
        Pair<Class, Object> mapping = this.mappingCache.get(cacheKey);
        if (mapping != null) {
            return mapping;
        }
        String[] mappingGroups = excelColumn.mapping().split(",");
        Properties properties = new Properties();
        Arrays.stream(mappingGroups).forEach(m -> {
            String[] mappingGroup = m.split(":");
            if (mappingGroup.length != 2) {
                throw new IllegalArgumentException("Illegal mapping");
            }
            properties.setProperty(mappingGroup[0], mappingGroup[1]);
        });
        String property = properties.getProperty(fieldVal.toString());
        if (property == null) {
            return Pair.of(field.getType(), fieldVal);
        }
        Pair<Class, Object> result = Pair.of(String.class, property);
        this.mappingCache.cache(cacheKey, result);
        return result;
    }
}

