/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.reader;

import com.github.liaochong.myexcel.core.converter.reader.AbstractReadConverter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.function.Function;

public class NumberReadConverter<R extends Number>
extends AbstractReadConverter<R> {
    private Function<String, R> func;

    private NumberReadConverter(Function<String, R> func) {
        this.func = func;
    }

    @Override
    protected R doConvert(String v, Field field) {
        v = PATTERN_NON_NUMBER.matcher(v).replaceAll("");
        BigDecimal bigDecimal = new BigDecimal(v);
        String realValue = bigDecimal.toPlainString();
        return (R)((Number)this.func.apply(realValue));
    }

    public static <R extends Number> NumberReadConverter<R> of(Function<String, R> func) {
        return new NumberReadConverter<R>(func);
    }
}

