/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.exception.StopReadException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.eventusermodel.XSSFSheetXMLHandler;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SaxHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(SaxHandler.class);
    private final Map<Integer, Field> fieldMap;
    private List<T> result;
    private T obj;
    private Class<T> dataType;
    private Consumer<T> consumer;
    private Function<T, Boolean> function;
    private Predicate<Row> rowFilter;
    private Predicate<T> beanFilter;
    private Row currentRow;
    private int count;

    public SaxHandler(Map<Integer, Field> fieldMap, List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        this.fieldMap = fieldMap;
        this.result = result;
        this.dataType = readConfig.getDataType();
        this.consumer = readConfig.getConsumer();
        this.function = readConfig.getFunction();
        this.rowFilter = readConfig.getRowFilter();
        this.beanFilter = readConfig.getBeanFilter();
    }

    public void startRow(int rowNum) {
        this.currentRow = new Row(rowNum);
        try {
            this.obj = this.dataType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public void endRow(int rowNum) {
        if (!this.rowFilter.test(this.currentRow)) {
            return;
        }
        if (!this.beanFilter.test(this.obj)) {
            return;
        }
        ++this.count;
        if (this.consumer != null) {
            this.consumer.accept(this.obj);
        } else if (this.function != null) {
            Boolean noStop = this.function.apply(this.obj);
            if (!noStop.booleanValue()) {
                throw new StopReadException();
            }
        } else {
            this.result.add(this.obj);
        }
    }

    public void cell(String cellReference, String formattedValue, XSSFComment comment) {
        if (!this.rowFilter.test(this.currentRow)) {
            return;
        }
        if (cellReference == null) {
            return;
        }
        short thisCol = new CellReference(cellReference).getCol();
        Field field = this.fieldMap.get(thisCol);
        if (field == null) {
            return;
        }
        ReadConverterContext.convert(formattedValue, field, this.obj);
    }

    public void endSheet() {
        log.info("Import completed, total number of rows {}", (Object)this.count);
    }
}

