/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractSimpleExcelBuilder;
import com.github.liaochong.myexcel.core.FreezePane;
import com.github.liaochong.myexcel.core.HtmlToExcelFactory;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.NonNull;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExcelBuilder
extends AbstractSimpleExcelBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultExcelBuilder.class);
    private Workbook workbook;
    private HtmlToExcelFactory htmlToExcelFactory;

    private DefaultExcelBuilder() {
    }

    public static DefaultExcelBuilder getInstance() {
        return new DefaultExcelBuilder();
    }

    public static DefaultExcelBuilder of(@NonNull Class<?> dataType) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        DefaultExcelBuilder defaultExcelBuilder = new DefaultExcelBuilder();
        defaultExcelBuilder.dataType = dataType;
        return defaultExcelBuilder;
    }

    public static DefaultExcelBuilder of(@NonNull Class<?> dataType, @NonNull Workbook workbook) {
        if (dataType == null) {
            throw new NullPointerException("dataType is marked non-null but is null");
        }
        if (workbook == null) {
            throw new NullPointerException("workbook is marked non-null but is null");
        }
        DefaultExcelBuilder defaultExcelBuilder = new DefaultExcelBuilder();
        defaultExcelBuilder.dataType = dataType;
        defaultExcelBuilder.workbook = workbook;
        return defaultExcelBuilder;
    }

    @Override
    public Workbook build(List<?> data, Class<?> ... groups) {
        this.htmlToExcelFactory = new HtmlToExcelFactory();
        try {
            boolean isMapBuild;
            this.htmlToExcelFactory.rowAccessWindowSize(this.rowAccessWindowSize).workbookType(this.workbookType).autoWidthStrategy(this.autoWidthStrategy);
            ArrayList<Table> tableList = new ArrayList<Table>();
            this.initStyleMap();
            if (data != null && (isMapBuild = data.stream().anyMatch(d -> d instanceof Map))) {
                return this.mapBuild(data, this.htmlToExcelFactory);
            }
            if (Objects.isNull(this.dataType)) {
                if (Objects.isNull(data) || data.isEmpty()) {
                    log.info("No valid data exists");
                    return this.htmlToExcelFactory.build(this.getTableWithHeader(), this.workbook);
                }
                Optional<Object> findResult = data.stream().filter(Objects::nonNull).findFirst();
                if (!findResult.isPresent()) {
                    log.info("No valid data exists");
                    return this.htmlToExcelFactory.build(this.getTableWithHeader(), this.workbook);
                }
                ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(findResult.get().getClass());
                List<Field> sortedFields = this.getFilteredFields(classFieldContainer, groups);
                if (sortedFields.isEmpty()) {
                    log.info("The specified field mapping does not exist");
                    return this.htmlToExcelFactory.build(this.getTableWithHeader(), this.workbook);
                }
                List<Pair<Class, ?>> contents = this.getRenderContent(data, sortedFields);
                Table table = this.createTable();
                List<Tr> thead = this.createThead();
                List<Tr> tbody = this.createTbody(contents, thead == null ? 0 : thead.size());
                if (thead != null) {
                    tbody.addAll(0, thead);
                }
                table.setTrList(tbody);
                tableList.add(table);
            } else {
                ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(this.dataType);
                List<Field> sortedFields = this.getFilteredFields(classFieldContainer, groups);
                Table table = this.createTable();
                List<Tr> thead = this.createThead();
                tableList.add(table);
                if (sortedFields.isEmpty()) {
                    if (thead != null) {
                        table.getTrList().addAll(thead);
                    }
                    log.info("The specified field mapping does not exist");
                    return this.htmlToExcelFactory.build(tableList, this.workbook);
                }
                if (data == null || data.isEmpty()) {
                    if (thead != null) {
                        table.getTrList().addAll(thead);
                    }
                    log.info("No valid data exists");
                    return this.htmlToExcelFactory.build(tableList, this.workbook);
                }
                List<Pair<Class, ?>> contents = this.getRenderContent(data, sortedFields);
                List<Tr> tbody = this.createTbody(contents, Objects.isNull(thead) ? 0 : thead.size());
                if (thead != null) {
                    tbody.addAll(0, thead);
                }
                table.setTrList(tbody);
            }
            if (this.fixedTitles && this.titleLevel > 0) {
                FreezePane freezePane = new FreezePane(this.titleLevel, 0);
                this.htmlToExcelFactory.freezePanes(freezePane);
            }
            return this.htmlToExcelFactory.build(tableList, this.workbook);
        }
        catch (Exception e) {
            this.htmlToExcelFactory.closeWorkbook();
            throw new RuntimeException(e);
        }
    }

    private Workbook mapBuild(List<Map<String, Object>> data, HtmlToExcelFactory htmlToExcelFactory) {
        if (null == this.fieldDisplayOrder) {
            throw new IllegalArgumentException();
        }
        if (data == null || data.isEmpty()) {
            log.info("No valid data exists");
            return htmlToExcelFactory.build(this.getTableWithHeader(), this.workbook);
        }
        List<Tr> thead = this.createThead();
        LinkedList<Tr> tbody = new LinkedList<Tr>();
        int size = data.size();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> d = data.get(i);
            if (d == null) continue;
            ArrayList contents = new ArrayList(d.size());
            for (String fieldName : this.fieldDisplayOrder) {
                Object val = d.get(fieldName);
                contents.add(Pair.of(val == null ? String.class : val.getClass(), val));
            }
            Tr tr2 = this.createTr(contents, i, thead.size());
            if (this.widths != null) {
                tr2.setColWidthMap(this.widths);
            }
            tbody.add(tr2);
        }
        tbody.addAll(0, thead);
        if (this.widths != null) {
            thead.forEach(tr -> tr.setColWidthMap(this.widths));
        }
        Table table = this.createTable();
        table.setTrList(tbody);
        if (this.fixedTitles && this.titleLevel > 0) {
            FreezePane freezePane = new FreezePane(this.titleLevel, 0);
            htmlToExcelFactory.freezePanes(freezePane);
        }
        ArrayList<Table> tableList = new ArrayList<Table>();
        tableList.add(table);
        return htmlToExcelFactory.build(tableList, this.workbook);
    }

    @Override
    public void close() throws IOException {
        if (this.htmlToExcelFactory != null) {
            this.htmlToExcelFactory.closeWorkbook();
        }
    }
}

