/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.animation;

import android.os.Handler;
import android.os.SystemClock;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.Interpolator;
import lecho.lib.hellocharts.animation.ChartAnimationListener;
import lecho.lib.hellocharts.animation.DummyChartAnimationListener;
import lecho.lib.hellocharts.animation.PieChartRotationAnimator;
import lecho.lib.hellocharts.view.PieChartView;

public class PieChartRotationAnimatorV8
implements PieChartRotationAnimator {
    long start;
    boolean isAnimationStarted = false;
    final PieChartView chart;
    private float startRotation = 0.0f;
    private float targetRotation = 0.0f;
    final long duration;
    final Handler handler;
    final Interpolator interpolator = new AccelerateDecelerateInterpolator();
    private ChartAnimationListener animationListener = new DummyChartAnimationListener();
    private final Runnable runnable = new Runnable(){

        @Override
        public void run() {
            long elapsed = SystemClock.uptimeMillis() - PieChartRotationAnimatorV8.this.start;
            if (elapsed > PieChartRotationAnimatorV8.this.duration) {
                PieChartRotationAnimatorV8.this.isAnimationStarted = false;
                PieChartRotationAnimatorV8.this.handler.removeCallbacks(PieChartRotationAnimatorV8.this.runnable);
                PieChartRotationAnimatorV8.this.chart.setChartRotation((int)PieChartRotationAnimatorV8.this.targetRotation, false);
                PieChartRotationAnimatorV8.this.animationListener.onAnimationFinished();
                return;
            }
            float scale = Math.min(PieChartRotationAnimatorV8.this.interpolator.getInterpolation((float)elapsed / (float)PieChartRotationAnimatorV8.this.duration), 1.0f);
            float rotation = PieChartRotationAnimatorV8.this.startRotation + (PieChartRotationAnimatorV8.this.targetRotation - PieChartRotationAnimatorV8.this.startRotation) * scale;
            rotation = (rotation % 360.0f + 360.0f) % 360.0f;
            PieChartRotationAnimatorV8.this.chart.setChartRotation((int)rotation, false);
            PieChartRotationAnimatorV8.this.handler.postDelayed((Runnable)this, 16L);
        }
    };

    public PieChartRotationAnimatorV8(PieChartView chart) {
        this(chart, 200L);
    }

    public PieChartRotationAnimatorV8(PieChartView chart, long duration) {
        this.chart = chart;
        this.duration = duration;
        this.handler = new Handler();
    }

    @Override
    public void startAnimation(float startRotation, float targetRotation) {
        this.startRotation = (startRotation % 360.0f + 360.0f) % 360.0f;
        this.targetRotation = (targetRotation % 360.0f + 360.0f) % 360.0f;
        this.isAnimationStarted = true;
        this.animationListener.onAnimationStarted();
        this.start = SystemClock.uptimeMillis();
        this.handler.post(this.runnable);
    }

    @Override
    public void cancelAnimation() {
        this.isAnimationStarted = false;
        this.handler.removeCallbacks(this.runnable);
        this.chart.setChartRotation((int)this.targetRotation, false);
        this.animationListener.onAnimationFinished();
    }

    @Override
    public boolean isAnimationStarted() {
        return this.isAnimationStarted;
    }

    @Override
    public void setChartAnimationListener(ChartAnimationListener animationListener) {
        this.animationListener = null == animationListener ? new DummyChartAnimationListener() : animationListener;
    }
}

