/*
 * Decompiled with CFR 0.152.
 */
package lecho.lib.hellocharts.model;

import java.util.ArrayList;
import java.util.List;
import lecho.lib.hellocharts.model.AbstractChartData;
import lecho.lib.hellocharts.model.Line;
import lecho.lib.hellocharts.model.PointValue;

public class LineChartData
extends AbstractChartData {
    public static final float DEFAULT_BASE_VALUE = 0.0f;
    private List<Line> lines = new ArrayList<Line>();
    private float baseValue = 0.0f;

    public LineChartData() {
    }

    public LineChartData(List<Line> lines) {
        this.setLines(lines);
    }

    public LineChartData(LineChartData data) {
        super(data);
        this.baseValue = data.baseValue;
        for (Line line : data.lines) {
            this.lines.add(new Line(line));
        }
    }

    @Override
    public void update(float scale) {
        for (Line line : this.lines) {
            line.update(scale);
        }
    }

    @Override
    public void finish() {
        for (Line line : this.lines) {
            line.finish();
        }
    }

    public List<Line> getLines() {
        return this.lines;
    }

    public LineChartData setLines(List<Line> lines) {
        this.lines = null == lines ? new ArrayList<Line>() : lines;
        return this;
    }

    public float getBaseValue() {
        return this.baseValue;
    }

    public LineChartData setBaseValue(float baseValue) {
        this.baseValue = baseValue;
        return this;
    }

    public static LineChartData generateDummyData() {
        int numValues = 4;
        LineChartData data = new LineChartData();
        ArrayList<PointValue> values = new ArrayList<PointValue>(4);
        values.add(new PointValue(0.0f, 2.0f));
        values.add(new PointValue(1.0f, 4.0f));
        values.add(new PointValue(2.0f, 3.0f));
        values.add(new PointValue(3.0f, 4.0f));
        Line line = new Line(values);
        ArrayList<Line> lines = new ArrayList<Line>(1);
        lines.add(line);
        data.setLines(lines);
        return data;
    }
}

