/*
 * Decompiled with CFR 0.152.
 */
package com.github.leandroborgesferreira.loadingbutton.utils;

import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.view.ContextThemeWrapper;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a8\u0006\t"}, d2={"parseGradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "drawable", "Landroid/graphics/drawable/Drawable;", "addLifecycleObserver", "", "Landroid/content/Context;", "observer", "Landroidx/lifecycle/LifecycleObserver;", "loading-button-android_release"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\ncom/github/leandroborgesferreira/loadingbutton/utils/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1#2:51\n*E\n"})
public final class UtilsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static final GradientDrawable parseGradientDrawable(@NotNull Drawable drawable2) {
        GradientDrawable gradientDrawable;
        Intrinsics.checkNotNullParameter((Object)drawable2, (String)"drawable");
        Drawable drawable3 = drawable2;
        if (drawable3 instanceof GradientDrawable) {
            gradientDrawable = (GradientDrawable)drawable2;
            return gradientDrawable;
        } else if (drawable3 instanceof ColorDrawable) {
            GradientDrawable gradientDrawable2;
            GradientDrawable $this$parseGradientDrawable_u24lambda_u240 = gradientDrawable2 = new GradientDrawable();
            boolean bl = false;
            $this$parseGradientDrawable_u24lambda_u240.setColor(((ColorDrawable)drawable2).getColor());
            gradientDrawable = gradientDrawable2;
            return gradientDrawable;
        } else {
            if (drawable3 instanceof InsetDrawable) {
                GradientDrawable gradientDrawable3;
                gradientDrawable = ((InsetDrawable)drawable2).getDrawable();
                if (gradientDrawable == null) throw new RuntimeException("Error reading background... Use a shape or a color in xml!");
                GradientDrawable innerDrawable = gradientDrawable;
                boolean bl = false;
                if (innerDrawable instanceof RippleDrawable) {
                    Drawable drawable4 = ((RippleDrawable)innerDrawable).getDrawable(0);
                    Intrinsics.checkNotNullExpressionValue((Object)drawable4, (String)"innerDrawable.getDrawable(0)");
                    gradientDrawable3 = UtilsKt.parseGradientDrawable(drawable4);
                } else {
                    gradientDrawable3 = UtilsKt.parseGradientDrawable((Drawable)innerDrawable);
                }
                gradientDrawable = gradientDrawable3;
                if (gradientDrawable3 != null) return gradientDrawable;
                throw new RuntimeException("Error reading background... Use a shape or a color in xml!");
            }
            if (drawable3 instanceof StateListDrawable) {
                if (!(((StateListDrawable)drawable2).getCurrent() instanceof GradientDrawable)) throw new RuntimeException("Error reading background... Use a shape or a color in xml!");
                Drawable drawable5 = ((StateListDrawable)drawable2).getCurrent();
                Intrinsics.checkNotNull((Object)drawable5, (String)"null cannot be cast to non-null type android.graphics.drawable.GradientDrawable");
                gradientDrawable = (GradientDrawable)drawable5;
                return gradientDrawable;
            } else {
                if (!(drawable3 instanceof LayerDrawable)) throw new RuntimeException("Error reading background... Use a shape or a color in xml!");
                Drawable drawable6 = ((LayerDrawable)drawable2).getDrawable(0);
                Intrinsics.checkNotNullExpressionValue((Object)drawable6, (String)"drawable.getDrawable(0)");
                gradientDrawable = UtilsKt.parseGradientDrawable(drawable6);
            }
        }
        return gradientDrawable;
    }

    public static final void addLifecycleObserver(@NotNull Context $this$addLifecycleObserver, @NotNull LifecycleObserver observer) {
        Intrinsics.checkNotNullParameter((Object)$this$addLifecycleObserver, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Context context = $this$addLifecycleObserver;
        if (context instanceof LifecycleOwner) {
            ((LifecycleOwner)$this$addLifecycleObserver).getLifecycle().addObserver(observer);
        } else if (context instanceof ContextThemeWrapper) {
            Context context2 = ((ContextThemeWrapper)$this$addLifecycleObserver).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            UtilsKt.addLifecycleObserver(context2, observer);
        }
    }
}

