/*
 * Decompiled with CFR 0.152.
 */
package redis.embedded.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import redis.embedded.exceptions.OsDetectionException;
import redis.embedded.util.Architecture;
import redis.embedded.util.OS;

public class OSDetector {
    public static OS getOS() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.contains("win")) {
            return OS.WINDOWS;
        }
        if (osName.contains("nix") || osName.contains("nux") || osName.contains("aix")) {
            return OS.UNIX;
        }
        if ("Mac OS X".equalsIgnoreCase(osName)) {
            return OS.MAC_OS_X;
        }
        throw new OsDetectionException("Unrecognized OS: " + osName);
    }

    public static Architecture getArchitecture() {
        OS os = OSDetector.getOS();
        switch (os) {
            case WINDOWS: {
                return OSDetector.getWindowsArchitecture();
            }
            case UNIX: {
                return OSDetector.getUnixArchitecture();
            }
            case MAC_OS_X: {
                return OSDetector.getMacOSXArchitecture();
            }
        }
        throw new OsDetectionException("Unrecognized OS: " + (Object)((Object)os));
    }

    private static Architecture getWindowsArchitecture() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        if (arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64")) {
            return Architecture.x86_64;
        }
        return Architecture.x86;
    }

    private static Architecture getUnixArchitecture() {
        BufferedReader input = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec("uname -m");
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.length() <= 0 || !line.contains("64")) continue;
                Architecture architecture = Architecture.x86_64;
                return architecture;
            }
        }
        catch (Exception e) {
            throw new OsDetectionException(e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ignored) {}
        }
        return Architecture.x86;
    }

    private static Architecture getMacOSXArchitecture() {
        BufferedReader input = null;
        try {
            String line;
            Process proc = Runtime.getRuntime().exec("sysctl hw");
            input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            while ((line = input.readLine()) != null) {
                if (line.length() <= 0 || !line.contains("cpu64bit_capable") || !line.trim().endsWith("1")) continue;
                Architecture architecture = Architecture.x86_64;
                return architecture;
            }
        }
        catch (Exception e) {
            throw new OsDetectionException(e);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ignored) {}
        }
        return Architecture.x86;
    }
}

