/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.addon.krasa;

import com.sun.codemodel.JClass;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JFormatter;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PrimitiveFixerPlugin
extends Plugin {
    private static final String OPTION_NAME = "XReplacePrimitives";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "-XReplacePrimitives    :   Replaces primitive types of fields and methods by proper Class, WARNING: must be defined before XhashCode or Xequals.  \n";
    }

    public boolean run(Outline outline, Options opt, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline co : outline.getClasses()) {
            HashMap<String, Class<Short>> hashMap = new HashMap<String, Class<Short>>();
            hashMap.put("int", Integer.class);
            hashMap.put("long", Long.class);
            hashMap.put("boolean", Boolean.class);
            hashMap.put("double", Double.class);
            hashMap.put("float", Float.class);
            hashMap.put("byte", Byte.class);
            hashMap.put("short", Short.class);
            Map fields = co.implClass.fields();
            for (Map.Entry stringJFieldVarEntry : fields.entrySet()) {
                Class o;
                JFieldVar fieldVar = (JFieldVar)stringJFieldVarEntry.getValue();
                JType type = fieldVar.type();
                if ("serialVersionUID".equals(fieldVar.name()) || !type.isPrimitive() || (o = (Class)hashMap.get(type.name())) == null) continue;
                JCodeModel jCodeModel = new JCodeModel();
                JClass newType = jCodeModel.ref(o);
                fieldVar.type((JType)newType);
                this.setReturnType((JType)newType, this.getMethodsMap(MethodType.GETTER, fieldVar, co));
                this.setParameter(newType, this.getMethodsMap(MethodType.SETTER, fieldVar, co));
            }
        }
        return true;
    }

    private void setParameter(JClass newType, JMethod jMethod) {
        if (jMethod != null) {
            JVar jVar = jMethod.listParams()[0];
            jVar.type((JType)newType);
        }
    }

    private void setReturnType(JType type, JMethod jMethod) {
        if (jMethod != null) {
            jMethod.type(type);
        }
    }

    private JMethod getMethodsMap(MethodType type, JFieldVar field, ClassOutline co) {
        String getterBody = "return " + field.name() + ";";
        for (JMethod method : co.implClass.methods()) {
            JStatement o;
            String s;
            String name = method.name();
            if (!method.type().isPrimitive() || !(MethodType.GETTER == type && (name.startsWith("is") || name.startsWith("get")) ? (s = PrimitiveFixerPlugin.getterBody(o = (JStatement)method.body().getContents().get(0))).trim().equals(getterBody) : MethodType.SETTER == type && name.startsWith("set") && (s = PrimitiveFixerPlugin.setterBody(o = (JStatement)method.body().getContents().get(0))).startsWith("this." + field.name() + " ="))) continue;
            return method;
        }
        throw new RuntimeException("Failed to find " + (Object)((Object)type) + " for " + field.name() + ", disable XReplacePrimitives and report a bug");
    }

    public static String getterBody(JStatement jStatement) {
        StringWriter w = new StringWriter();
        jStatement.state(new JFormatter((Writer)w));
        return w.toString();
    }

    public static String setterBody(JStatement jStatement) {
        StringWriter w = new StringWriter();
        jStatement.state(new JFormatter((Writer)w));
        return w.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MethodType {
        GETTER,
        SETTER;

    }
}

