/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.github.kongchen.swagger.docgen.mavenplugin.SecurityDefinition;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.SpringMvcApiReader;
import com.google.common.collect.Sets;
import io.swagger.annotations.Api;
import io.swagger.config.FilterFactory;
import io.swagger.core.filter.SpecFilter;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.springframework.web.bind.annotation.RestController;

public class SpringMavenDocumentSource
extends AbstractDocumentSource {
    private final SpecFilter specFilter = new SpecFilter();

    public SpringMavenDocumentSource(ApiSource apiSource, Log log, String encoding) throws MojoFailureException {
        super(log, apiSource);
        if (encoding != null) {
            this.encoding = encoding;
        }
    }

    @Override
    public void loadDocuments() throws GenerateException {
        if (this.apiSource.getSwaggerInternalFilter() != null) {
            try {
                this.LOG.info((CharSequence)("Setting filter configuration: " + this.apiSource.getSwaggerInternalFilter()));
                FilterFactory.setFilter((SwaggerSpecFilter)((SwaggerSpecFilter)Class.forName(this.apiSource.getSwaggerInternalFilter()).newInstance()));
            }
            catch (Exception e) {
                throw new GenerateException("Cannot load: " + this.apiSource.getSwaggerInternalFilter(), e);
            }
        }
        Sets.SetView<Class<?>> validClasses = this.getValidClasses();
        this.swagger = this.resolveApiReader().read((Set<Class<?>>)validClasses);
        if (this.apiSource.getSecurityDefinitions() != null) {
            for (SecurityDefinition sd : this.apiSource.getSecurityDefinitions()) {
                for (Map.Entry<String, SecuritySchemeDefinition> entry : sd.getDefinitions().entrySet()) {
                    this.swagger.addSecurityDefinition(entry.getKey(), entry.getValue());
                }
            }
            Map defs = this.swagger.getSecurityDefinitions();
            TreeMap sortedDefs = new TreeMap();
            sortedDefs.putAll(defs);
            this.swagger.setSecurityDefinitions(sortedDefs);
        }
        if (FilterFactory.getFilter() != null) {
            this.swagger = new SpecFilter().filter(this.swagger, FilterFactory.getFilter(), new HashMap(), new HashMap(), new HashMap());
        }
    }

    Sets.SetView<Class<?>> getValidClasses() {
        return Sets.union(this.apiSource.getValidClasses(Api.class), this.apiSource.getValidClasses(RestController.class));
    }

    private ClassSwaggerReader resolveApiReader() throws GenerateException {
        String customReaderClassName = this.apiSource.getSwaggerApiReader();
        if (customReaderClassName == null) {
            SpringMvcApiReader reader = new SpringMvcApiReader(this.swagger, this.LOG);
            reader.setTypesToSkip(this.typesToSkip);
            return reader;
        }
        return this.getCustomApiReader(customReaderClassName);
    }
}

