/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.jaxrs;

import com.github.kongchen.swagger.docgen.jaxrs.JaxrsParameterExtension;
import com.sun.jersey.api.core.InjectParam;
import com.sun.jersey.core.header.FormDataContentDisposition;
import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.PropertyBuilder;
import io.swagger.util.AllowableValues;
import io.swagger.util.AllowableValuesUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.BeanParam;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.reflections.util.Utils;

public class BeanParamInjectParamExtention
extends AbstractSwaggerExtension
implements SwaggerExtension {
    public List<Parameter> extractParameters(List<Annotation> annotations, Type type, Set<Type> typesToSkip, Iterator<SwaggerExtension> chain) {
        Class cls = TypeUtils.getRawType((Type)type, (Type)type);
        ArrayList<Parameter> output = new ArrayList<Parameter>();
        if (this.shouldIgnoreClass(cls) || typesToSkip.contains(type)) {
            typesToSkip.add(type);
            return output;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof BeanParam) && !(annotation instanceof InjectParam)) continue;
            return this.extractParameters(cls);
        }
        if (chain.hasNext()) {
            return chain.next().extractParameters(annotations, type, typesToSkip, chain);
        }
        return null;
    }

    private List<Parameter> extractParameters(Class<?> cls) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (AccessibleObject f : this.getDeclaredAndInheritedFieldsAndMethods(cls)) {
            SerializableParameter parameter = null;
            int i = 0;
            int apiParaIdx = -1;
            for (Annotation annotation : f.getAnnotations()) {
                if (annotation instanceof ApiParam && !((ApiParam)annotation).hidden()) {
                    apiParaIdx = i;
                }
                ++i;
                Type paramType = this.extractType(f, cls);
                parameter = JaxrsParameterExtension.getParameter(paramType, parameter, annotation);
            }
            if (parameter == null) continue;
            if (apiParaIdx != -1) {
                Map args;
                ApiParam param = (ApiParam)f.getAnnotations()[apiParaIdx];
                parameter.setDescription(param.value());
                parameter.setRequired(param.required());
                parameter.setAccess(param.access());
                AllowableValues allowableValues = AllowableValuesUtils.create((String)param.allowableValues());
                if (allowableValues != null && (args = allowableValues.asPropertyArguments()).containsKey(PropertyBuilder.PropertyId.ENUM)) {
                    parameter.setEnum((List)args.get(PropertyBuilder.PropertyId.ENUM));
                }
                if (!Utils.isEmpty((String)param.name())) {
                    parameter.setName(param.name());
                }
            }
            parameters.add((Parameter)parameter);
        }
        return parameters;
    }

    public boolean shouldIgnoreClass(Class<?> cls) {
        return FormDataContentDisposition.class.equals(cls);
    }

    private List<AccessibleObject> getDeclaredAndInheritedFieldsAndMethods(Class<?> c) {
        ArrayList<AccessibleObject> accessibleObjects = new ArrayList<AccessibleObject>();
        this.recurseGetDeclaredAndInheritedFields(c, accessibleObjects);
        this.recurseGetDeclaredAndInheritedMethods(c, accessibleObjects);
        return accessibleObjects;
    }

    private void recurseGetDeclaredAndInheritedFields(Class<?> c, List<AccessibleObject> fields) {
        fields.addAll(Arrays.asList(c.getDeclaredFields()));
        Class<?> superClass = c.getSuperclass();
        if (superClass != null) {
            this.recurseGetDeclaredAndInheritedFields(superClass, fields);
        }
    }

    private void recurseGetDeclaredAndInheritedMethods(Class<?> c, List<AccessibleObject> methods) {
        methods.addAll(Arrays.asList(c.getDeclaredMethods()));
        Class<?> superClass = c.getSuperclass();
        if (superClass != null) {
            this.recurseGetDeclaredAndInheritedMethods(superClass, methods);
        }
    }

    private Type extractType(AccessibleObject accessibleObject, Type defaulType) {
        Method method;
        if (accessibleObject instanceof Field) {
            return ((Field)accessibleObject).getType();
        }
        if (accessibleObject instanceof Method && (method = (Method)accessibleObject).getParameterTypes().length == 1) {
            return method.getParameterTypes()[0];
        }
        return defaulType;
    }
}

