/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.kongchen.swagger.docgen.GenerateException;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.BasicAuthDefinition;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SecurityDefinition {
    private String name;
    private String type;
    private String json;

    public Map<String, SecuritySchemeDefinition> getDefinitions() throws GenerateException {
        HashMap<String, SecuritySchemeDefinition> map = new HashMap<String, SecuritySchemeDefinition>();
        if (this.name != null && this.type != null) {
            map.put(this.name, this.getSecuritySchemeDefinitionByNameAndType());
        } else if (this.json != null) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JsonNode tree = objectMapper.readTree(this.getClass().getResourceAsStream(this.json));
                Iterator fit = tree.fieldNames();
                while (fit.hasNext()) {
                    String field = (String)fit.next();
                    JsonNode node = tree.get(field);
                    String type = node.get("type").asText();
                    SecuritySchemeDefinition ssd = this.getSecuritySchemeDefinitionByType(type, node);
                    if (ssd == null) continue;
                    map.put(field, ssd);
                }
            }
            catch (IOException e) {
                throw new GenerateException(e);
            }
        }
        return map;
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByType(String type, JsonNode node) throws GenerateException {
        ObjectMapper mapper = new ObjectMapper();
        OAuth2Definition def = null;
        if (type.equals(new OAuth2Definition().getType())) {
            def = new OAuth2Definition();
            if (node != null) {
                try {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), OAuth2Definition.class);
                }
                catch (IOException e) {
                    throw new GenerateException(e);
                }
            }
        } else if (type.equals(new BasicAuthDefinition().getType())) {
            def = new BasicAuthDefinition();
            if (node != null) {
                try {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), BasicAuthDefinition.class);
                }
                catch (IOException e) {
                    throw new GenerateException(e);
                }
            }
        } else if (type.equals(new ApiKeyAuthDefinition().getType())) {
            def = new ApiKeyAuthDefinition();
            if (node != null) {
                try {
                    def = (SecuritySchemeDefinition)mapper.readValue(node.traverse(), ApiKeyAuthDefinition.class);
                }
                catch (IOException e) {
                    throw new GenerateException(e);
                }
            }
        }
        return def;
    }

    private SecuritySchemeDefinition getSecuritySchemeDefinitionByNameAndType() throws GenerateException {
        ObjectMapper mapper = new ObjectMapper();
        final String _type = this.type;
        SecuritySchemeDefinition def = new SecuritySchemeDefinition(){
            private String type;
            {
                this.type = _type;
            }

            public String getType() {
                return this.type;
            }

            public void setType(String type) {
            }
        };
        JsonNode node = mapper.valueToTree((Object)def);
        SecuritySchemeDefinition securitySchemeDefinition = this.getSecuritySchemeDefinitionByType(this.type, node);
        return securitySchemeDefinition;
    }

    public String getJson() {
        return this.json;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

