/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.mavenplugin;

import com.github.kongchen.swagger.docgen.AbstractDocumentSource;
import com.github.kongchen.swagger.docgen.GenerateException;
import com.github.kongchen.swagger.docgen.LogAdapter;
import com.github.kongchen.swagger.docgen.mavenplugin.ApiSource;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.core.Documentation;
import com.wordnik.swagger.core.DocumentationEndPoint;
import com.wordnik.swagger.core.SwaggerSpec;
import com.wordnik.swagger.jaxrs.HelpApi;
import com.wordnik.swagger.jaxrs.JaxrsApiSpecParser;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.plugin.logging.Log;

public class MavenDocumentSource
extends AbstractDocumentSource {
    private final ApiSource apiSource;
    private Map<String, Documentation> docMap = new TreeMap<String, Documentation>();

    public MavenDocumentSource(ApiSource apiSource, Log log) {
        super(new LogAdapter(log), apiSource.getOutputPath(), apiSource.getOutputTemplate(), apiSource.getSwaggerDirectory());
        this.setApiVersion(apiSource.getApiVersion());
        this.setBasePath(apiSource.getBasePath());
        this.apiSource = apiSource;
    }

    @Override
    public void loadDocuments() throws GenerateException {
        this.serviceDocument = new Documentation(this.apiSource.getApiVersion(), SwaggerSpec.version(), this.apiSource.getBasePath(), null);
        for (Class c : this.apiSource.getValidClasses()) {
            Documentation doc = null;
            try {
                doc = this.getDocFromClass(c, this.getApiVersion(), this.getBasePath());
            }
            catch (Exception e) {
                throw new GenerateException(e);
            }
            if (doc == null) continue;
            this.LOG.info("Detect Resource:" + c.getName());
            this.serviceDocument.addApi(new DocumentationEndPoint(doc.getResourcePath(), ""));
            this.docMap.put(doc.getResourcePath(), doc);
        }
        for (Documentation doc : this.docMap.values()) {
            if (!this.apiSource.isWithFormatSuffix()) {
                for (DocumentationEndPoint endPoint : doc.getApis()) {
                    endPoint.setPath(endPoint.getPath().replaceAll("\\.\\{format\\}", ""));
                }
            }
            this.acceptDocument(doc);
        }
    }

    private Documentation getDocFromClass(Class c, String apiVersion, String basePath) throws Exception {
        Api resource = c.getAnnotation(Api.class);
        if (resource == null) {
            return null;
        }
        JaxrsApiSpecParser parser = new JaxrsApiSpecParser(c, apiVersion, SwaggerSpec.version(), basePath, resource.value());
        return new HelpApi().filterDocs(parser.parse(), null, null, null, null);
    }
}

