/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.launch;

import com.github.kklisura.cdt.launch.support.annotations.ChromeArgument;
import java.util.HashMap;
import java.util.Map;

public class ChromeArguments {
    public static final String USER_DATA_DIR_ARGUMENT = "user-data-dir";
    @ChromeArgument(value="headless")
    private Boolean headless;
    @ChromeArgument(value="remote-debugging-port")
    private Integer remoteDebuggingPort = 0;
    @ChromeArgument(value="no-default-browser-check")
    private Boolean noDefaultBrowserCheck;
    @ChromeArgument(value="no-first-run")
    private Boolean noFirstRun;
    @ChromeArgument(value="user-data-dir")
    private String userDataDir;
    @ChromeArgument(value="incognito")
    private Boolean incognito;
    @ChromeArgument(value="disable-gpu")
    private Boolean disableGpu;
    @ChromeArgument(value="hide-scrollbars")
    private Boolean hideScrollbars;
    @ChromeArgument(value="mute-audio")
    private Boolean muteAudio;
    @ChromeArgument(value="disable-background-networking")
    private Boolean disableBackgroundNetworking;
    @ChromeArgument(value="disable-background-timer-throttling")
    private Boolean disableBackgroundTimerThrottling;
    @ChromeArgument(value="disable-client-side-phishing-detection")
    private Boolean disableClientSidePhishingDetection;
    @ChromeArgument(value="disable-default-apps")
    private Boolean disableDefaultApps;
    @ChromeArgument(value="disable-extensions")
    private Boolean disableExtensions;
    @ChromeArgument(value="disable-hang-monitor")
    private Boolean disableHangMonitor;
    @ChromeArgument(value="disable-popup-blocking")
    private Boolean disablePopupBlocking;
    @ChromeArgument(value="disable-prompt-on-repost")
    private Boolean disablePromptOnRepost;
    @ChromeArgument(value="disable-sync")
    private Boolean disableSync;
    @ChromeArgument(value="disable-translate")
    private Boolean disableTranslate;
    @ChromeArgument(value="metrics-recording-only")
    private Boolean metricsRecordingOnly;
    @ChromeArgument(value="safebrowsing-disable-auto-update")
    private Boolean safebrowsingDisableAutoUpdate;
    private Map<String, Object> additionalArguments;

    public Boolean getHeadless() {
        return this.headless;
    }

    public Map<String, Object> getAdditionalArguments() {
        if (this.additionalArguments == null) {
            this.additionalArguments = new HashMap<String, Object>();
        }
        return this.additionalArguments;
    }

    public Boolean getNoDefaultBrowserCheck() {
        return this.noDefaultBrowserCheck;
    }

    public Boolean getNoFirstRun() {
        return this.noFirstRun;
    }

    public String getUserDataDir() {
        return this.userDataDir;
    }

    public Integer getRemoteDebuggingPort() {
        return this.remoteDebuggingPort;
    }

    public Boolean getIncognito() {
        return this.incognito;
    }

    public Boolean getDisableGpu() {
        return this.disableGpu;
    }

    public Boolean getHideScrollbars() {
        return this.hideScrollbars;
    }

    public Boolean getMuteAudio() {
        return this.muteAudio;
    }

    public Boolean getDisableBackgroundNetworking() {
        return this.disableBackgroundNetworking;
    }

    public Boolean getDisableBackgroundTimerThrottling() {
        return this.disableBackgroundTimerThrottling;
    }

    public Boolean getDisableClientSidePhishingDetection() {
        return this.disableClientSidePhishingDetection;
    }

    public Boolean getDisableDefaultApps() {
        return this.disableDefaultApps;
    }

    public Boolean getDisableExtensions() {
        return this.disableExtensions;
    }

    public Boolean getDisableHangMonitor() {
        return this.disableHangMonitor;
    }

    public Boolean getDisablePopupBlocking() {
        return this.disablePopupBlocking;
    }

    public Boolean getDisablePromptOnRepost() {
        return this.disablePromptOnRepost;
    }

    public Boolean getDisableSync() {
        return this.disableSync;
    }

    public Boolean getDisableTranslate() {
        return this.disableTranslate;
    }

    public Boolean getMetricsRecordingOnly() {
        return this.metricsRecordingOnly;
    }

    public Boolean getSafebrowsingDisableAutoUpdate() {
        return this.safebrowsingDisableAutoUpdate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder defaults(boolean headless) {
        Builder builder = new Builder().noFirstRun().noDefaultBrowserCheck().disableBackgroundNetworking().disableBackgroundTimerThrottling().disableClientSidePhishingDetection().disableDefaultApps().disableExtensions().disableHangMonitor().disablePopupBlocking().disablePromptOnRepost().disableSync().disableTranslate().metricsRecordingOnly().safebrowsingDisableAutoUpdate();
        if (headless) {
            builder.headless().disableGpu().hideScrollbars().muteAudio();
        }
        return builder;
    }

    public static class Builder {
        private ChromeArguments arguments = new ChromeArguments();

        private Builder() {
        }

        public Builder headless(Boolean headless) {
            this.arguments.headless = headless;
            return this;
        }

        public Builder headless() {
            return this.headless(Boolean.TRUE);
        }

        public Builder remoteDebuggingPort(Integer remoteDebuggingPort) {
            if (remoteDebuggingPort == null) {
                remoteDebuggingPort = 0;
            }
            this.arguments.remoteDebuggingPort = remoteDebuggingPort;
            return this;
        }

        public Builder additionalArguments(String key, Object value) {
            this.arguments.getAdditionalArguments().put(key, value);
            return this;
        }

        public Builder additionalArguments(Map<String, Object> additionalArguments) {
            this.arguments.additionalArguments = additionalArguments;
            return this;
        }

        public Builder noDefaultBrowserCheck(Boolean noDefaultBrowserCheck) {
            this.arguments.noDefaultBrowserCheck = noDefaultBrowserCheck;
            return this;
        }

        public Builder noDefaultBrowserCheck() {
            return this.noDefaultBrowserCheck(Boolean.TRUE);
        }

        public Builder noFirstRun(Boolean noFirstRun) {
            this.arguments.noFirstRun = noFirstRun;
            return this;
        }

        public Builder noFirstRun() {
            return this.noFirstRun(Boolean.TRUE);
        }

        public Builder userDataDir(String userDataDir) {
            this.arguments.userDataDir = userDataDir;
            return this;
        }

        public Builder incognito(Boolean incognito) {
            this.arguments.incognito = incognito;
            return this;
        }

        public Builder incognito() {
            return this.incognito(Boolean.TRUE);
        }

        public Builder disableGpu(Boolean disableGpu) {
            this.arguments.disableGpu = disableGpu;
            return this;
        }

        public Builder disableGpu() {
            return this.disableGpu(Boolean.TRUE);
        }

        public Builder hideScrollbars(Boolean hideScrollbars) {
            this.arguments.hideScrollbars = hideScrollbars;
            return this;
        }

        public Builder hideScrollbars() {
            return this.hideScrollbars(Boolean.TRUE);
        }

        public Builder muteAudio(Boolean muteAudio) {
            this.arguments.muteAudio = muteAudio;
            return this;
        }

        public Builder muteAudio() {
            return this.muteAudio(Boolean.TRUE);
        }

        public Builder disableBackgroundNetworking(Boolean disableBackgroundNetworking) {
            this.arguments.disableBackgroundNetworking = disableBackgroundNetworking;
            return this;
        }

        public Builder disableBackgroundNetworking() {
            return this.disableBackgroundNetworking(Boolean.TRUE);
        }

        public Builder disableBackgroundTimerThrottling(Boolean disableBackgroundTimerThrottling) {
            this.arguments.disableBackgroundTimerThrottling = disableBackgroundTimerThrottling;
            return this;
        }

        public Builder disableBackgroundTimerThrottling() {
            return this.disableBackgroundTimerThrottling(Boolean.TRUE);
        }

        public Builder disableClientSidePhishingDetection(Boolean disableClientSidePhishingDetection) {
            this.arguments.disableClientSidePhishingDetection = disableClientSidePhishingDetection;
            return this;
        }

        public Builder disableClientSidePhishingDetection() {
            return this.disableClientSidePhishingDetection(Boolean.TRUE);
        }

        public Builder disableDefaultApps(Boolean disableDefaultApps) {
            this.arguments.disableDefaultApps = disableDefaultApps;
            return this;
        }

        public Builder disableDefaultApps() {
            return this.disableDefaultApps(Boolean.TRUE);
        }

        public Builder disableExtensions(Boolean disableExtensions) {
            this.arguments.disableExtensions = disableExtensions;
            return this;
        }

        public Builder disableExtensions() {
            return this.disableExtensions(Boolean.TRUE);
        }

        public Builder disableHangMonitor(Boolean disableHangMonitor) {
            this.arguments.disableHangMonitor = disableHangMonitor;
            return this;
        }

        public Builder disableHangMonitor() {
            return this.disableHangMonitor(Boolean.TRUE);
        }

        public Builder disablePopupBlocking(Boolean disablePopupBlocking) {
            this.arguments.disablePopupBlocking = disablePopupBlocking;
            return this;
        }

        public Builder disablePopupBlocking() {
            return this.disablePopupBlocking(Boolean.TRUE);
        }

        public Builder disablePromptOnRepost(Boolean disablePromptOnRepost) {
            this.arguments.disablePromptOnRepost = disablePromptOnRepost;
            return this;
        }

        public Builder disablePromptOnRepost() {
            return this.disablePromptOnRepost(Boolean.TRUE);
        }

        public Builder disableSync(Boolean disableSync) {
            this.arguments.disableSync = disableSync;
            return this;
        }

        public Builder disableSync() {
            return this.disableSync(Boolean.TRUE);
        }

        public Builder disableTranslate(Boolean disableTranslate) {
            this.arguments.disableTranslate = disableTranslate;
            return this;
        }

        public Builder disableTranslate() {
            return this.disableTranslate(Boolean.TRUE);
        }

        public Builder metricsRecordingOnly(Boolean metricsRecordingOnly) {
            this.arguments.metricsRecordingOnly = metricsRecordingOnly;
            return this;
        }

        public Builder metricsRecordingOnly() {
            return this.metricsRecordingOnly(Boolean.TRUE);
        }

        public Builder safebrowsingDisableAutoUpdate(Boolean safebrowsingDisableAutoUpdate) {
            this.arguments.safebrowsingDisableAutoUpdate = safebrowsingDisableAutoUpdate;
            return this;
        }

        public Builder safebrowsingDisableAutoUpdate() {
            return this.safebrowsingDisableAutoUpdate(Boolean.TRUE);
        }

        public ChromeArguments build() {
            return this.arguments;
        }
    }
}

