#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
<%@page contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@taglib uri="http://java.sun.com/jsp/jstl/fmt" prefix="fmt"%>
<%@taglib uri="http://www.springframework.org/security/tags" prefix="sec" %>
<%--Context path--%>
<c:set var="cp" value="${symbol_dollar}{pageContext.request.contextPath}"/>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="utf-8"/>
        <title>Home page</title>
        <link rel="stylesheet" href="${symbol_dollar}{cp}/wro/all.css"/>
        <script src="${symbol_dollar}{cp}/wro/all.js"></script>
        <script>
            function ajaxGetUser(){
                ${symbol_dollar}.ajax({
                    type : "POST",
                    url : "${symbol_dollar}{cp}/admin/users",
                    dataType : "json",
                    headers: {"${symbol_dollar}{_csrf.headerName}":"${symbol_dollar}{_csrf.token}"},
                    data: {},
                    cache: false,
                    error:function(jqXHR,  statusText){
                        alert("Exception prone when fetch users' data with "+statusText+":["+jqXHR.status+"]:${symbol_escape}n${symbol_escape}t"+jqXHR.statusText);
                    },
                    success:function(data){  
                        if(data.total==0){
                            ${symbol_dollar}("${symbol_pound}listuser").html("");
                        }else{
                            var html="<table border=${symbol_escape}"1${symbol_escape}"  class=${symbol_escape}"ui-widget-content ui-corner-all${symbol_escape}"><thead><tr><th><fmt:message key="account"/></th><th><fmt:message key="name"/></th><th><fmt:message key="birthday"/></th></tr></thead><tbody>";
                            for(var i=0;i<data.total;i++){
                                var user = data.users[i];
                                <sec:authorize access="hasRole('ROLE_ADMIN')" var="isAdmin">
                                html = html + "<tr><td><a href=${symbol_escape}"${symbol_dollar}{cp}/member/edit/"+user.account+"${symbol_escape}">"+user.account+"</a></td><td>"+user.name+"</td><td>"+user.birthday+"</td></tr>";
                                </sec:authorize>
                                <c:if test="${symbol_dollar}{not isAdmin}">
                                html = html + "<tr><td>"+user.account+"</td><td>"+user.name+"</td><td>"+user.birthday+"</td></tr>";
                                </c:if>
                            }
                            html += "</tbody></table>";
                            ${symbol_dollar}("${symbol_pound}listuser").hide().html(html).show("bounce",{},2000);
                        }
                    }
                });
            }
            ${symbol_dollar}(function() {
                ${symbol_dollar}("center") .show("puff");
            });
        </script>
    </head>
    <body>
        <table border="0" style="width:100%">
            <sec:authorize access="authenticated" var="logined">
                <tr>
                    <td><a href="${symbol_dollar}{cp}/changePassword"><fmt:message key="changePassword"/></a></td>
                    <td align="right">
                        <form action="${symbol_dollar}{cp}/j_spring_security_logout" method="post" style="display: inline">
                            <!--<input type="hidden" name="${symbol_dollar}{_csrf.parameterName}" value="${symbol_dollar}{_csrf.token}"/>-->
                            <sec:csrfInput />
                            <input type="submit" value="<sec:authentication property="principal.username"/>&nbsp;<fmt:message key="logout"/>"/>
                        </form>
                    </td>
                </tr>
            </sec:authorize>
            <c:if test="${symbol_dollar}{not logined}">
                <tr>
                    <td align="right"><a href="${symbol_dollar}{cp}/user/myinfo"><fmt:message key="myinfo"/></a></td>
                </tr>
            </c:if>
        </table>

    <center  style="display: none"><c:set var="world"><fmt:message key="world"/></c:set>
        <h1><fmt:message key="hello"/> ${symbol_dollar}{empty member?world:member.name}</h1>
        <c:if test="${symbol_dollar}{not empty member}">
            <table id="myinfo" border="1" class="ui-widget-content ui-corner-all">
                <tr><th colspan="2"><fmt:message key="myinfo"/></th></tr>
                <tr><td><fmt:message key="account"/>:</td><td>${symbol_dollar}{member.account}</td></tr>
                <tr><td><fmt:message key="name"/>:</td><td>${symbol_dollar}{member.name}</td></tr>
                <tr><td><fmt:message key="enabled"/>:</td><td><c:if test="${symbol_dollar}{'Y' eq member.enabled}"><fmt:message key="true"/></c:if>
                        <c:if test="${symbol_dollar}{'Y' ne member.enabled}"><fmt:message key="false"/></c:if></td></tr>
                <tr><td><fmt:message key="birthday"/>:</td><td><fmt:formatDate value="${symbol_dollar}{member.birthday}" pattern="yyyy/MM/dd"/></td></tr>
                <tr><td><fmt:message key="role"/>:</td><td>
                        <c:forEach var="authority" items="${symbol_dollar}{member.authorities}">
                            ${symbol_dollar}{authority.authority}&nbsp;
                        </c:forEach>
                    </td></tr>
            </table>
        </c:if><br/>
        <c:set var="adminAjaxList"><fmt:message key="adminAjaxList"/></c:set>
        <input type="button" onclick="ajaxGetUser()" value="<c:out value="${symbol_dollar}{adminAjaxList}" escapeXml="true"/>"/>
        <div id="listuser"></div>
    </center>
</body>
</html>
