/*
 * Decompiled with CFR 0.152.
 */
package scpc.model;

import java.io.Serializable;
import java.util.Objects;
import scpc.model.IItem;
import scpc.model.IRule;

public class BonusItem<T>
implements IItem<T> {
    private final IRule<T> rule;
    private final IItem<T> item;
    private double fracQuantity = 0.0;

    public BonusItem(IRule<T> rule, IItem<T> item) {
        this.rule = rule;
        this.item = item;
    }

    @Override
    public Serializable getIdentity() {
        return this.item.getIdentity();
    }

    @Override
    public T as() {
        return this.item.as();
    }

    @Override
    public long getQuantity() {
        return Math.round(Math.floor(this.fracQuantity));
    }

    @Override
    public void setQuantity(long quantity) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public IRule<T> getRule() {
        return this.rule;
    }

    public double getFracQuantity() {
        return this.fracQuantity;
    }

    public BonusItem<T> incFracQuantity(double fracQuantity) {
        this.fracQuantity += fracQuantity;
        this.item.setQuantity(this.getQuantity());
        return this;
    }

    public void setFracQuantity(double fracQuantity) {
        this.fracQuantity = fracQuantity;
        this.item.setQuantity(this.getQuantity());
    }

    @Override
    public double getSalePrice() {
        return this.item.getSalePrice();
    }

    @Override
    public double getRegularPrice() {
        return this.item.getRegularPrice();
    }

    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + Objects.hashCode(this.rule);
        hash = 11 * hash + Objects.hashCode(this.item);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isAssignableFrom(obj.getClass())) {
            return false;
        }
        BonusItem other = (BonusItem)obj;
        return Objects.equals(this.item.as(), other.as()) && this.getQuantity() == other.getQuantity();
    }

    public String toString() {
        return this.item.toString();
    }
}

