/*
 * Decompiled with CFR 0.152.
 */
package scpc.model;

import java.io.Serializable;
import java.util.Objects;
import scpc.model.IItem;

public class SingleItem<T>
implements IItem<T> {
    private final IItem<T> item;
    private final int sequenceNum;
    private boolean serialLast = false;
    private boolean exclusiveLock = false;

    public SingleItem(IItem<T> item, int sequenceNum) {
        this.item = item;
        this.sequenceNum = sequenceNum;
    }

    @Override
    public Serializable getIdentity() {
        return this.item.getIdentity();
    }

    @Override
    public T as() {
        return this.item.as();
    }

    @Override
    public long getQuantity() {
        return 1L;
    }

    @Override
    public void setQuantity(long quantity) {
    }

    @Override
    public double getSalePrice() {
        return this.item.getSalePrice();
    }

    @Override
    public double getOriginalPrice() {
        return this.item.getOriginalPrice();
    }

    public IItem<T> getItem() {
        return this.item;
    }

    public int getSequenceNum() {
        return this.sequenceNum;
    }

    public boolean isSerialLast() {
        return this.serialLast;
    }

    public void setSerialLast(boolean serialLast) {
        this.serialLast = serialLast;
    }

    public boolean isExclusiveLock() {
        return this.exclusiveLock;
    }

    public SingleItem<T> setExclusiveLock(boolean exclusiveLock) {
        this.exclusiveLock = exclusiveLock;
        return this;
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.sequenceNum;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleItem other = (SingleItem)obj;
        if (!Objects.equals(this.item, other.item)) {
            return false;
        }
        return this.sequenceNum == other.sequenceNum;
    }

    public String toString() {
        return "singularize \"" + this.sequenceNum + "." + this.item.toString() + "\"";
    }
}

