/*
 * Decompiled with CFR 0.152.
 */
package scpc;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scpc.model.BonusItem;
import scpc.model.CurrentItem;
import scpc.model.IChainRule;
import scpc.model.IItem;
import scpc.model.ILeafRule;
import scpc.model.IRule;
import scpc.model.SingleItem;

public class Calculator {
    private static final Logger logger = LoggerFactory.getLogger(Calculator.class);

    public static <T> List<SingleItem<T>> flat(Set<? extends IItem<T>> cartItems) {
        ArrayList<IItem<T>> items = new ArrayList<IItem<T>>(cartItems);
        Collections.sort(items, new Comparator<IItem<T>>(){

            @Override
            public int compare(IItem o1, IItem o2) {
                return o1.getSalePrice() < o2.getSalePrice() ? 1 : (o1.getSalePrice() == o2.getSalePrice() ? (o1.getOriginalPrice() < o2.getOriginalPrice() ? 1 : (o1.getOriginalPrice() == o2.getOriginalPrice() ? 0 : -1)) : -1);
            }
        });
        int idx = 1;
        ArrayList<SingleItem<T>> flats = new ArrayList<SingleItem<T>>();
        for (IItem iItem : items) {
            int i = 0;
            while ((long)i < iItem.getQuantity()) {
                SingleItem si = new SingleItem(iItem, idx++, i + 1);
                si.setSerialLast((long)i == iItem.getQuantity() - 1L);
                flats.add(si);
                ++i;
            }
        }
        return flats;
    }

    private static <T> List<SingleItem<T>> rearrange(List<SingleItem<T>> items) {
        SingleItem<T> preSingle = null;
        IItem<T> preitem = null;
        int serialNum = 1;
        int sequenceNum = 1;
        ArrayList<SingleItem<T>> flats = new ArrayList<SingleItem<T>>();
        for (int i = 0; i < items.size(); ++i) {
            SingleItem<T> curritem = items.get(i);
            if (curritem.isExclusiveLock()) continue;
            if (preitem == null || !preitem.equals(curritem.getItem())) {
                preitem = curritem.getItem();
                serialNum = 1;
                if (preSingle != null) {
                    preSingle.setSerialLast(true);
                }
            }
            curritem = new SingleItem<T>(curritem.getItem(), sequenceNum++, serialNum++);
            flats.add(curritem);
            preSingle = curritem;
        }
        if (preSingle != null) {
            preSingle.setSerialLast(true);
        }
        return flats;
    }

    public static <T> List<T> purification(Collection<? extends IItem<T>> items) {
        ArrayList<T> res = new ArrayList<T>(items.size());
        for (IItem<T> item : items) {
            res.add(item.as());
        }
        return res;
    }

    public static <T> Collection<BonusItem<T>> calcBonus(List<? extends IRule<T>> rules, Set<? extends IItem<T>> cartItems) throws ScriptException {
        HashMap<Serializable, BonusItem<T>> bonuses = new HashMap<Serializable, BonusItem<T>>();
        Collections.sort(rules, new Comparator<IRule<T>>(){

            @Override
            public int compare(IRule<T> o1, IRule<T> o2) {
                return o1.getPriority() - o2.getPriority();
            }
        });
        List<SingleItem<T>> items = Calculator.flat(cartItems);
        for (int i = 0; i < rules.size(); ++i) {
            IRule<T> rule = rules.get(i);
            logger.debug("[{}] is going to apply.", rule);
            if (!Calculator.iterate(rule, items, bonuses) || i == rules.size() - 1) continue;
            items = Calculator.rearrange(items);
        }
        return bonuses.values();
    }

    private static <T> void unlockItems(Collection<SingleItem<T>> items) {
        for (SingleItem<T> item : items) {
            item.setExclusiveLock(false);
        }
        items.clear();
    }

    private static <T> boolean iterate(IRule<T> rule, List<SingleItem<T>> cartItems, Map<Serializable, BonusItem<T>> bonuses) throws ScriptException {
        return Calculator.iterate(rule, cartItems, bonuses, false);
    }

    private static <T> boolean iterate(IRule<T> rule, List<SingleItem<T>> cartItems, Map<Serializable, BonusItem<T>> bonuses, boolean backOnTriggered) throws ScriptException {
        ArrayList<SingleItem<T>> lockedItems = new ArrayList<SingleItem<T>>();
        boolean hasPromote = false;
        if (rule.isLeaf()) {
            ILeafRule lrule = (ILeafRule)rule;
            int idx = 0;
            for (SingleItem<T> item : cartItems) {
                double quantity;
                if (item.isExclusiveLock() || !rule.contains(item)) continue;
                BigDecimal op = BigDecimal.valueOf(item.getOriginalPrice()).setScale(rule.getPriceScale(), RoundingMode.HALF_EVEN);
                BigDecimal sp = BigDecimal.valueOf(item.getSalePrice()).setScale(rule.getPriceScale(), RoundingMode.HALF_EVEN);
                logger.debug("\t inspect [{}-{}].", (Object)(++idx), item);
                lockedItems.add(item.setExclusiveLock(true));
                rule.containsCountInc().sumOfContainsOriginalPriceInc(op).sumOfContainsSalePriceInc(sp).sumOfSerialOriginalPriceInc(op).sumOfSerialSalePriceInc(sp);
                if (rule.isTriggered(item) && (quantity = lrule.evalQuantity()) > 0.0) {
                    IItem ruleBonus = lrule.getBonus();
                    String primaryKey = String.format("%d-%s", rule.hashCode(), CurrentItem.isCurrent(ruleBonus) ? item.getIdentity() : ruleBonus.getIdentity());
                    BonusItem<T> bonus = bonuses.get(primaryKey);
                    if (bonus == null) {
                        IRule<T> topMostRule;
                        IRule<T> iRule = topMostRule = rule.getPrevious() == null ? rule : rule.getPrevious();
                        while (topMostRule.getPrevious() != null) {
                            topMostRule = topMostRule.getPrevious();
                        }
                        bonus = new BonusItem<T>(topMostRule, CurrentItem.isCurrent(ruleBonus) ? lrule.getCurrentAsBonus(item) : lrule.getBonus());
                        bonuses.put((Serializable)((Object)primaryKey), bonus);
                        logger.debug("init bonus[{}:{}]", (Object)primaryKey, bonus);
                    }
                    if (lrule.isLastQuantityOnly()) {
                        bonus.setFracQuantity(quantity);
                    } else {
                        bonus.incFracQuantity(quantity);
                    }
                    lockedItems.clear();
                    hasPromote = true;
                    if (hasPromote && backOnTriggered) break;
                }
                if (!item.isSerialLast()) continue;
                rule.resetSumOfSerialOriginalPrice();
                rule.resetSumOfSerialSalePrice();
            }
        } else {
            int idx = 0;
            for (SingleItem<T> item : cartItems) {
                if (!item.isExclusiveLock() && rule.contains(item)) {
                    BigDecimal op = BigDecimal.valueOf(item.getOriginalPrice()).setScale(rule.getPriceScale(), RoundingMode.HALF_EVEN);
                    BigDecimal sp = BigDecimal.valueOf(item.getSalePrice()).setScale(rule.getPriceScale(), RoundingMode.HALF_EVEN);
                    logger.debug("\t inspect [{}-{}].", (Object)(++idx), item);
                    lockedItems.add(item.setExclusiveLock(true));
                    rule.containsCountInc().sumOfContainsOriginalPriceInc(op).sumOfContainsSalePriceInc(sp).sumOfSerialOriginalPriceInc(op).sumOfSerialSalePriceInc(sp);
                    if (rule.isTriggered(item) && Calculator.iterate(((IChainRule)rule).getNext(), cartItems, bonuses, true)) {
                        lockedItems.clear();
                        hasPromote = true;
                        if (hasPromote && backOnTriggered) break;
                    }
                    if (item.isSerialLast()) {
                        rule.resetSumOfSerialOriginalPrice();
                        rule.resetSumOfSerialSalePrice();
                    }
                }
                if (!hasPromote) continue;
                rule.resetSumOfPrice();
            }
        }
        Calculator.unlockItems(lockedItems);
        if (hasPromote && backOnTriggered) {
            rule.resetSumOfPrice();
        }
        return hasPromote;
    }
}

