/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.CronSchedule;
import java.io.Serializable;
import java.util.Random;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import utils.EventLogger;

@Configuration
public class MultiInstanceRecurringConfiguration {
    public static final TaskDescriptor<ScheduleAndCustomer> MULTI_INSTANCE_RECURRING_TASK = TaskDescriptor.of((String)"multi-instance-recurring-task", ScheduleAndCustomer.class);

    public static void start(ExampleContext ctx) {
        CronSchedule cron = new CronSchedule("%s * * * * *".formatted(new Random().nextInt(59)));
        Customer customer = new Customer(String.valueOf(new Random().nextInt(10000)));
        ScheduleAndCustomer data = new ScheduleAndCustomer(cron, customer);
        ctx.log("Scheduling instance of recurring task " + MULTI_INSTANCE_RECURRING_TASK.getTaskName() + " with data: " + String.valueOf(data));
        ctx.schedulerClient.scheduleIfNotExists(MULTI_INSTANCE_RECURRING_TASK.instance(customer.id).data((Object)data).scheduledAccordingToData());
    }

    @Bean
    public Task<ScheduleAndCustomer> multiInstanceRecurring() {
        return Tasks.recurringWithPersistentSchedule(MULTI_INSTANCE_RECURRING_TASK).execute((taskInstance, executionContext) -> {
            ScheduleAndCustomer data = (ScheduleAndCustomer)taskInstance.getData();
            EventLogger.logTask(MULTI_INSTANCE_RECURRING_TASK, "Ran according to schedule '%s' for customer %s".formatted(data.getSchedule(), data.getData()));
        });
    }

    public static class Customer
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final String id;

        private Customer() {
            this(null);
        }

        public Customer(String id) {
            this.id = id;
        }

        public String toString() {
            return "Customer{id='" + this.id + "'}";
        }
    }

    public static class ScheduleAndCustomer
    implements ScheduleAndData {
        private static final long serialVersionUID = 1L;
        private final CronSchedule schedule;
        private final Customer customer;

        private ScheduleAndCustomer() {
            this(null, null);
        }

        public ScheduleAndCustomer(CronSchedule schedule, Customer customer) {
            this.schedule = schedule;
            this.customer = customer;
        }

        public CronSchedule getSchedule() {
            return this.schedule;
        }

        public Customer getData() {
            return this.customer;
        }

        public String toString() {
            return "ScheduleAndCustomer{schedule=" + String.valueOf(this.schedule) + ", customer=" + String.valueOf(this.customer) + "}";
        }
    }
}

