/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples.boot.config;

import com.github.kagkarlsson.examples.boot.ExampleContext;
import com.github.kagkarlsson.scheduler.task.HasTaskName;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskWithDataDescriptor;
import com.github.kagkarlsson.scheduler.task.TaskWithoutDataDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Instant;
import java.util.Random;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.support.TransactionTemplate;
import utils.EventLogger;
import utils.Utils;

@Configuration
public class ParallellJobConfiguration {
    public static final TaskWithoutDataDescriptor PARALLEL_JOB_SPAWNER = new TaskWithoutDataDescriptor("parallel-job-spawner");
    public static final TaskWithDataDescriptor<Integer> PARALLEL_JOB = new TaskWithDataDescriptor("parallel-job", Integer.class);
    private TransactionTemplate tx;

    public ParallellJobConfiguration(TransactionTemplate tx) {
        this.tx = tx;
    }

    public static void start(ExampleContext ctx) {
        ctx.log("Starting recurring task " + PARALLEL_JOB_SPAWNER.getTaskName() + ". Initial execution-time will be now (deviating from defined schedule).");
        ctx.schedulerClient.reschedule(PARALLEL_JOB_SPAWNER.instanceId("recurring"), Instant.now());
    }

    @Bean
    public Task<Void> parallelJobSpawner() {
        return Tasks.recurring((TaskDescriptor)PARALLEL_JOB_SPAWNER, (Schedule)Schedules.cron((String)"0/20 * * * * *")).doNotScheduleOnStartup().execute((taskInstance, executionContext) -> {
            this.tx.executeWithoutResult(status -> {
                for (int quarter = 1; quarter < 5; ++quarter) {
                    executionContext.getSchedulerClient().schedule(PARALLEL_JOB.instance("q" + quarter, (Object)quarter), Instant.now());
                }
            });
            EventLogger.logTask((HasTaskName)PARALLEL_JOB_SPAWNER, "Ran. Scheduled tasks for generating quarterly report.");
        });
    }

    @Bean
    public Task<Integer> parallelJob() {
        return Tasks.oneTime(PARALLEL_JOB).execute((taskInstance, executionContext) -> {
            long startTime = System.currentTimeMillis();
            Utils.sleep(new Random().nextInt(10) * 1000);
            String threadName = Thread.currentThread().getName();
            EventLogger.logTask(PARALLEL_JOB, String.format("Ran. Generated report for quarter Q%s  (in thread '%s', duration %sms)", taskInstance.getData(), threadName, System.currentTimeMillis() - startTime));
        });
    }
}

