/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.serializer.GsonSerializer;
import com.github.kagkarlsson.scheduler.serializer.Serializer;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.TaskDescriptor;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import javax.sql.DataSource;

public class JsonSerializerMain
extends Example {
    public static final TaskDescriptor<JsonData> JSON_TASK = TaskDescriptor.of((String)"json-task", JsonData.class);

    public static void main(String[] args) {
        new JsonSerializerMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask myAdhocTask = Tasks.oneTime(JSON_TASK).execute((inst, ctx) -> System.out.println("Executed! Custom data: " + String.valueOf(inst.getData())));
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{myAdhocTask}).serializer((Serializer)new GsonSerializer()).registerShutdownHook().pollingInterval(Duration.ofSeconds(1L)).build();
        scheduler.start();
        scheduler.schedule(JSON_TASK.instance("id1").data((Object)new JsonData(1001L, Instant.now())).scheduledTo(Instant.now().plusSeconds(1L)));
    }

    public static class JsonData {
        public long id;
        private Instant time;

        private JsonData() {
        }

        public JsonData(long id, Instant time) {
            this.id = id;
            this.time = time;
        }

        public Instant getTime() {
            return this.time;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            JsonData jsonData = (JsonData)o;
            return this.id == jsonData.id && Objects.equals(this.time, jsonData.time);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.time);
        }

        public String toString() {
            return "JsonData{id=" + this.id + ", time=" + String.valueOf(this.time) + "}";
        }
    }
}

