/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.examples.helpers.ExampleHelpers;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.FailureHandler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.OneTimeTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import java.time.Duration;
import java.time.Instant;
import javax.sql.DataSource;

public class ExponentialBackoffMain
extends Example {
    public static void main(String[] args) {
        new ExponentialBackoffMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        OneTimeTask failingTask = Tasks.oneTime((String)"exponential_backoff_task").onFailure((FailureHandler)new FailureHandler.ExponentialBackoffFailureHandler(Duration.ofSeconds(1L))).execute((taskInstance, executionContext) -> {
            throw new RuntimeException("simulated task exception");
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{failingTask}).pollingInterval(Duration.ofSeconds(2L)).build();
        scheduler.schedule(failingTask.instance("1"), Instant.now());
        ExampleHelpers.registerShutdownHook(scheduler);
        scheduler.start();
    }
}

