/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.PlainScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTaskWithPersistentSchedule;
import com.github.kagkarlsson.scheduler.task.helper.ScheduleAndData;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import javax.sql.DataSource;

public class StatefulRecurringTaskWithPersistentScheduleMain
extends Example {
    public static void main(String[] args) {
        new StatefulRecurringTaskWithPersistentScheduleMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        RecurringTaskWithPersistentSchedule task = Tasks.recurringWithPersistentSchedule((String)"dynamic-recurring-task", ScheduleAndInteger.class).executeStateful((taskInstance, executionContext) -> {
            System.out.printf("Instance: '%s' ran using persistent schedule '%s' and data '%s'\n", taskInstance.getId(), ((ScheduleAndInteger)((Object)((Object)taskInstance.getData()))).getSchedule(), ((ScheduleAndInteger)((Object)((Object)taskInstance.getData()))).getData());
            return ((ScheduleAndInteger)((Object)((Object)taskInstance.getData()))).returnIncremented();
        });
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[]{task}).pollingInterval(Duration.ofSeconds(1L)).registerShutdownHook().build();
        scheduler.start();
        this.sleep(2000);
        scheduler.schedule(task.schedulableInstance("id1", (ScheduleAndData)new ScheduleAndInteger((Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(3L)), 1)));
    }

    public static class ScheduleAndInteger
    extends PlainScheduleAndData {
        public ScheduleAndInteger(Schedule schedule, Integer data) {
            super(schedule, (Object)data);
        }

        public ScheduleAndInteger returnIncremented() {
            return new ScheduleAndInteger(super.getSchedule(), (Integer)super.getData() + 1);
        }
    }
}

