/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.examples;

import com.github.kagkarlsson.examples.helpers.Example;
import com.github.kagkarlsson.examples.helpers.ExampleHelpers;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.SchedulerClient;
import com.github.kagkarlsson.scheduler.task.Task;
import com.github.kagkarlsson.scheduler.task.helper.RecurringTask;
import com.github.kagkarlsson.scheduler.task.helper.Tasks;
import com.github.kagkarlsson.scheduler.task.schedule.Schedule;
import com.github.kagkarlsson.scheduler.task.schedule.Schedules;
import java.time.Duration;
import java.time.Instant;
import java.util.stream.IntStream;
import javax.sql.DataSource;

public class DeletingUnresolvedTasksMain
extends Example {
    public static void main(String[] args) {
        new DeletingUnresolvedTasksMain().runWithDatasource();
    }

    @Override
    public void run(DataSource dataSource) {
        RecurringTask unresolvedTask = Tasks.recurring((String)"unresolved1", (Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(1L))).execute((taskInstance, executionContext) -> System.out.println("Ran"));
        RecurringTask unresolvedTask2 = Tasks.recurring((String)"unresolved2", (Schedule)Schedules.fixedDelay((Duration)Duration.ofSeconds(1L))).execute((taskInstance, executionContext) -> System.out.println("Ran"));
        SchedulerClient client = SchedulerClient.Builder.create((DataSource)dataSource, (Task[])new Task[0]).build();
        client.schedule(unresolvedTask.instance("recurring"), Instant.now());
        client.schedule(unresolvedTask2.instance("recurring"), Instant.now().plusSeconds(10L));
        Scheduler scheduler = Scheduler.create((DataSource)dataSource, (Task[])new Task[0]).pollingInterval(Duration.ofSeconds(1L)).heartbeatInterval(Duration.ofSeconds(5L)).deleteUnresolvedAfter(Duration.ofSeconds(20L)).build();
        ExampleHelpers.registerShutdownHook(scheduler);
        scheduler.start();
        IntStream.range(0, 5).forEach(i -> {
            scheduler.fetchScheduledExecutions(e -> {});
            scheduler.getFailingExecutions(Duration.ZERO);
        });
    }
}

