/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task;

import com.github.kagkarlsson.scheduler.TaskRepository;
import com.github.kagkarlsson.scheduler.task.Execution;
import com.github.kagkarlsson.scheduler.task.ExecutionComplete;
import java.time.Instant;

public class ExecutionOperations<T> {
    private final TaskRepository taskRepository;
    private final Execution execution;

    public ExecutionOperations(TaskRepository taskRepository, Execution execution) {
        this.taskRepository = taskRepository;
        this.execution = execution;
    }

    public void stop() {
        this.taskRepository.remove(this.execution);
    }

    public void reschedule(ExecutionComplete completed, Instant nextExecutionTime) {
        if (completed.getResult() == ExecutionComplete.Result.OK) {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, completed.getTimeDone(), this.execution.lastFailure, 0);
        } else {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, this.execution.lastSuccess, completed.getTimeDone(), this.execution.consecutiveFailures + 1);
        }
    }

    public void reschedule(ExecutionComplete completed, Instant nextExecutionTime, T newData) {
        if (completed.getResult() == ExecutionComplete.Result.OK) {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, newData, completed.getTimeDone(), this.execution.lastFailure, 0);
        } else {
            this.taskRepository.reschedule(this.execution, nextExecutionTime, newData, this.execution.lastSuccess, completed.getTimeDone(), this.execution.consecutiveFailures + 1);
        }
    }
}

