/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler.task.helper;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.Scheduler;
import com.github.kagkarlsson.scheduler.task.Task;
import java.time.Instant;
import java.util.function.Function;

class ScheduleOnStartup<T> {
    String instance;
    T data;
    Function<Instant, Instant> firstExecutionTime;

    ScheduleOnStartup(String instance) {
        this(instance, null);
    }

    ScheduleOnStartup(String instance, T data) {
        this(instance, data, Function.identity());
    }

    ScheduleOnStartup(String instance, T data, Function<Instant, Instant> firstExecutionTime) {
        this.firstExecutionTime = firstExecutionTime;
        this.instance = instance;
        this.data = data;
    }

    public void apply(Scheduler scheduler, Clock clock, Task<T> task) {
        if (this.data == null) {
            scheduler.schedule(task.instance(this.instance), this.firstExecutionTime.apply(clock.now()));
        } else {
            scheduler.schedule(task.instance(this.instance, this.data), this.firstExecutionTime.apply(clock.now()));
        }
    }
}

