/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.shaded.cronutils.mapper;

import com.github.kagkarlsson.shaded.cronutils.Function;
import com.github.kagkarlsson.shaded.cronutils.mapper.ConstantsMapper;
import com.github.kagkarlsson.shaded.cronutils.model.Cron;
import com.github.kagkarlsson.shaded.cronutils.model.CronType;
import com.github.kagkarlsson.shaded.cronutils.model.SingleCron;
import com.github.kagkarlsson.shaded.cronutils.model.definition.CronDefinition;
import com.github.kagkarlsson.shaded.cronutils.model.definition.CronDefinitionBuilder;
import com.github.kagkarlsson.shaded.cronutils.model.field.CronField;
import com.github.kagkarlsson.shaded.cronutils.model.field.CronFieldName;
import com.github.kagkarlsson.shaded.cronutils.model.field.constraint.FieldConstraints;
import com.github.kagkarlsson.shaded.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.github.kagkarlsson.shaded.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.github.kagkarlsson.shaded.cronutils.model.field.definition.FieldDefinition;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.Always;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.FieldExpression;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.On;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.QuestionMark;
import com.github.kagkarlsson.shaded.cronutils.model.field.expression.visitor.ValueMappingFieldExpressionVisitor;
import com.github.kagkarlsson.shaded.cronutils.model.field.value.IntegerFieldValue;
import com.github.kagkarlsson.shaded.cronutils.model.field.value.SpecialChar;
import com.github.kagkarlsson.shaded.cronutils.utils.Preconditions;
import com.github.kagkarlsson.shaded.cronutils.utils.VisibleForTesting;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;

public class CronMapper {
    private final Map<CronFieldName, Function<CronField, CronField>> mappings;
    private final Function<Cron, Cron> cronRules;
    private final CronDefinition to;

    public CronMapper(CronDefinition from, CronDefinition to, Function<Cron, Cron> cronRules) {
        Preconditions.checkNotNull(from, "Source CronDefinition must not be null");
        this.to = Preconditions.checkNotNull(to, "Destination CronDefinition must not be null");
        this.cronRules = Preconditions.checkNotNull(cronRules, "CronRules must not be null");
        this.mappings = new EnumMap<CronFieldName, Function<CronField, CronField>>(CronFieldName.class);
        this.buildMappings(from, to);
    }

    public Cron map(Cron cron) {
        Preconditions.checkNotNull(cron, "Cron must not be null");
        ArrayList<CronField> fields = new ArrayList<CronField>();
        for (CronFieldName name : CronFieldName.values()) {
            if (!this.mappings.containsKey((Object)name)) continue;
            fields.add(this.mappings.get((Object)name).apply(cron.retrieve(name)));
        }
        return this.cronRules.apply(new SingleCron(this.to, fields)).validate();
    }

    public static CronMapper fromCron4jToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper fromQuartzToCron4j() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.CRON4J), CronMapper.sameCron());
    }

    public static CronMapper fromQuartzToUnix() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronMapper.sameCron());
    }

    public static CronMapper fromUnixToQuartz() {
        return new CronMapper(CronDefinitionBuilder.instanceDefinitionFor(CronType.UNIX), CronDefinitionBuilder.instanceDefinitionFor(CronType.QUARTZ), CronMapper.setQuestionMark());
    }

    public static CronMapper sameCron(CronDefinition cronDefinition) {
        return new CronMapper(cronDefinition, cronDefinition, CronMapper.sameCron());
    }

    private static Function<Cron, Cron> sameCron() {
        return cron -> cron;
    }

    private static Function<Cron, Cron> setQuestionMark() {
        return cron -> {
            CronField dow = cron.retrieve(CronFieldName.DAY_OF_WEEK);
            CronField dom = cron.retrieve(CronFieldName.DAY_OF_MONTH);
            if (dow == null && dom == null) {
                return cron;
            }
            if (dow.getExpression() instanceof QuestionMark || dom.getExpression() instanceof QuestionMark) {
                return cron;
            }
            EnumMap<CronFieldName, CronField> fields = new EnumMap<CronFieldName, CronField>(CronFieldName.class);
            fields.putAll(cron.retrieveFieldsAsMap());
            if (dow.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_WEEK, new CronField(CronFieldName.DAY_OF_WEEK, FieldExpression.questionMark(), ((CronField)fields.get((Object)CronFieldName.DAY_OF_WEEK)).getConstraints()));
            } else if (dom.getExpression() instanceof Always) {
                fields.put(CronFieldName.DAY_OF_MONTH, new CronField(CronFieldName.DAY_OF_MONTH, FieldExpression.questionMark(), ((CronField)fields.get((Object)CronFieldName.DAY_OF_MONTH)).getConstraints()));
            } else {
                cron.validate();
            }
            return new SingleCron(cron.getCronDefinition(), new ArrayList<CronField>(fields.values()));
        };
    }

    private void buildMappings(CronDefinition from, CronDefinition to) {
        Map<CronFieldName, FieldDefinition> sourceFieldDefinitions = this.getFieldDefinitions(from);
        Map<CronFieldName, FieldDefinition> destFieldDefinitions = this.getFieldDefinitions(to);
        boolean startedDestMapping = false;
        boolean startedSourceMapping = false;
        for (CronFieldName name : CronFieldName.values()) {
            FieldDefinition destinationFieldDefinition = destFieldDefinitions.get((Object)name);
            FieldDefinition sourceFieldDefinition = sourceFieldDefinitions.get((Object)name);
            if (destinationFieldDefinition != null) {
                startedDestMapping = true;
            }
            if (sourceFieldDefinition != null) {
                startedSourceMapping = true;
            }
            if (startedDestMapping && destinationFieldDefinition == null) break;
            if (!startedSourceMapping && destinationFieldDefinition != null) {
                this.mappings.put(name, CronMapper.returnOnZeroExpression(name));
            }
            if (startedSourceMapping && sourceFieldDefinition == null && destinationFieldDefinition != null) {
                this.mappings.put(name, CronMapper.returnAlwaysExpression(name));
            }
            if (sourceFieldDefinition == null || destinationFieldDefinition == null) continue;
            if (CronFieldName.DAY_OF_WEEK.equals((Object)name)) {
                this.mappings.put(name, CronMapper.dayOfWeekMapping((DayOfWeekFieldDefinition)sourceFieldDefinition, (DayOfWeekFieldDefinition)destinationFieldDefinition));
                continue;
            }
            if (CronFieldName.DAY_OF_MONTH.equals((Object)name)) {
                this.mappings.put(name, CronMapper.dayOfMonthMapping(sourceFieldDefinition, destinationFieldDefinition));
                continue;
            }
            this.mappings.put(name, CronMapper.returnSameExpression());
        }
    }

    private Map<CronFieldName, FieldDefinition> getFieldDefinitions(CronDefinition from) {
        EnumMap<CronFieldName, FieldDefinition> result = new EnumMap<CronFieldName, FieldDefinition>(CronFieldName.class);
        for (FieldDefinition fieldDefinition : from.getFieldDefinitions()) {
            result.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        return result;
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnSameExpression() {
        return field -> field;
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnOnZeroExpression(CronFieldName name) {
        return field -> {
            FieldConstraints constraints = FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance();
            return new CronField(name, new On(new IntegerFieldValue(0)), constraints);
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnAlwaysExpression(CronFieldName name) {
        return field -> new CronField(name, FieldExpression.always(), FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance());
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfWeekMapping(DayOfWeekFieldDefinition sourceDef, DayOfWeekFieldDefinition targetDef) {
        return field -> {
            FieldExpression expression = field.getExpression();
            FieldExpression dest = null;
            dest = expression.accept(new ValueMappingFieldExpressionVisitor(fieldValue -> {
                if (fieldValue instanceof IntegerFieldValue) {
                    return new IntegerFieldValue(ConstantsMapper.weekDayMapping(sourceDef.getMondayDoWValue(), targetDef.getMondayDoWValue(), ((IntegerFieldValue)fieldValue).getValue()));
                }
                return fieldValue;
            }));
            if (expression instanceof QuestionMark && !targetDef.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                dest = FieldExpression.always();
            }
            return new CronField(CronFieldName.DAY_OF_WEEK, dest, targetDef.getConstraints());
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfMonthMapping(FieldDefinition sourceDef, FieldDefinition targetDef) {
        return field -> {
            FieldExpression expression;
            FieldExpression dest = expression = field.getExpression();
            if (expression instanceof QuestionMark && !targetDef.getConstraints().getSpecialChars().contains((Object)SpecialChar.QUESTION_MARK)) {
                dest = FieldExpression.always();
            }
            return new CronField(CronFieldName.DAY_OF_MONTH, dest, targetDef.getConstraints());
        };
    }
}

