/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.shaded.cronutils.model.field.expression;

import com.github.kagkarlsson.shaded.cronutils.model.field.expression.FieldExpression;
import com.github.kagkarlsson.shaded.cronutils.model.field.value.IntegerFieldValue;
import com.github.kagkarlsson.shaded.cronutils.utils.Preconditions;

public class Every
extends FieldExpression {
    private static final long serialVersionUID = -1103196842332906994L;
    private final FieldExpression expression;
    private final IntegerFieldValue period;

    public Every(IntegerFieldValue time) {
        this(Every.always(), time);
    }

    public Every(FieldExpression expression, IntegerFieldValue period) {
        this.expression = Preconditions.checkNotNull(expression, "Expression must not be null");
        this.period = period == null ? new IntegerFieldValue(1) : period;
    }

    public IntegerFieldValue getPeriod() {
        return this.period;
    }

    public FieldExpression getExpression() {
        return this.expression;
    }

    @Override
    public String asString() {
        String expressionAsString = this.expression.asString();
        if ("*".equals(expressionAsString) && this.period.getValue() == 1) {
            return expressionAsString;
        }
        return String.format("%s/%s", expressionAsString, this.period);
    }
}

