/*
 * Decompiled with CFR 0.152.
 */
package com.github.kagkarlsson.scheduler;

import com.github.kagkarlsson.scheduler.Clock;
import com.github.kagkarlsson.scheduler.SystemClock;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Waiter {
    private static final Logger LOG = LoggerFactory.getLogger(Waiter.class);
    private Object lock;
    private boolean woken = false;
    private final Duration duration;
    private Clock clock;
    private boolean isWaiting = false;

    public Waiter(Duration duration) {
        this(duration, new SystemClock());
    }

    public Waiter(Duration duration, Clock clock) {
        this(duration, clock, new Object());
    }

    Waiter(Duration duration, Clock clock, Object lock) {
        this.duration = duration;
        this.clock = clock;
        this.lock = lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doWait() throws InterruptedException {
        long millis = this.duration.toMillis();
        if (millis > 0L) {
            Instant waitUntil = this.clock.now().plusMillis(millis);
            while (this.clock.now().isBefore(waitUntil)) {
                Object object = this.lock;
                synchronized (object) {
                    this.woken = false;
                    LOG.debug("Waiter start wait.");
                    this.isWaiting = true;
                    this.lock.wait(millis);
                    this.isWaiting = false;
                    if (this.woken) {
                        LOG.debug("Waiter woken, it had {}ms left to wait.", (Object)(waitUntil.toEpochMilli() - this.clock.now().toEpochMilli()));
                        break;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wake() {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isWaiting) {
                return false;
            }
            this.woken = true;
            this.lock.notify();
            return true;
        }
    }
}

